/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;

public class ListChannelsIterable
implements SdkIterable<ListChannelsResponse> {
    private final CloudTrailClient client;
    private final ListChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelsIterable(CloudTrailClient client, ListChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public Iterator<ListChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelsResponseFetcher
    implements SyncPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelsResponse nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsIterable.this.client.listChannels(ListChannelsIterable.this.firstRequest);
            }
            return ListChannelsIterable.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

