/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Advanced event selectors let you create fine-grained selectors for the following AWS CloudTrail event record ﬁelds.
 * They help you control costs by logging only those events that are important to you. For more information about
 * advanced event selectors, see <a
 * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
 * data events for trails</a> in the <i>AWS CloudTrail User Guide</i>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>readOnly</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>eventSource</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>eventName</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>eventCategory</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>resources.type</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>resources.ARN</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * You cannot apply both event selectors and advanced event selectors to a trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedEventSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedEventSelector.Builder, AdvancedEventSelector> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AdvancedEventSelector::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AdvancedFieldSelector>> FIELD_SELECTORS_FIELD = SdkField
            .<List<AdvancedFieldSelector>> builder(MarshallingType.LIST)
            .memberName("FieldSelectors")
            .getter(getter(AdvancedEventSelector::fieldSelectors))
            .setter(setter(Builder::fieldSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedFieldSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedFieldSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            FIELD_SELECTORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<AdvancedFieldSelector> fieldSelectors;

    private AdvancedEventSelector(BuilderImpl builder) {
        this.name = builder.name;
        this.fieldSelectors = builder.fieldSelectors;
    }

    /**
     * <p>
     * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
     * </p>
     * 
     * @return An optional, descriptive name for an advanced event selector, such as
     *         "Log data events for only two S3 buckets".
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the FieldSelectors property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFieldSelectors() {
        return fieldSelectors != null && !(fieldSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains all selector statements in an advanced event selector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains all selector statements in an advanced event selector.
     */
    public final List<AdvancedFieldSelector> fieldSelectors() {
        return fieldSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldSelectors() ? fieldSelectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedEventSelector)) {
            return false;
        }
        AdvancedEventSelector other = (AdvancedEventSelector) obj;
        return Objects.equals(name(), other.name()) && hasFieldSelectors() == other.hasFieldSelectors()
                && Objects.equals(fieldSelectors(), other.fieldSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedEventSelector").add("Name", name())
                .add("FieldSelectors", hasFieldSelectors() ? fieldSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FieldSelectors":
            return Optional.ofNullable(clazz.cast(fieldSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdvancedEventSelector, T> g) {
        return obj -> g.apply((AdvancedEventSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedEventSelector> {
        /**
         * <p>
         * An optional, descriptive name for an advanced event selector, such as
         * "Log data events for only two S3 buckets".
         * </p>
         * 
         * @param name
         *        An optional, descriptive name for an advanced event selector, such as
         *        "Log data events for only two S3 buckets".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains all selector statements in an advanced event selector.
         * </p>
         * 
         * @param fieldSelectors
         *        Contains all selector statements in an advanced event selector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSelectors(Collection<AdvancedFieldSelector> fieldSelectors);

        /**
         * <p>
         * Contains all selector statements in an advanced event selector.
         * </p>
         * 
         * @param fieldSelectors
         *        Contains all selector statements in an advanced event selector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSelectors(AdvancedFieldSelector... fieldSelectors);

        /**
         * <p>
         * Contains all selector statements in an advanced event selector.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdvancedFieldSelector>.Builder} avoiding
         * the need to create one manually via {@link List<AdvancedFieldSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdvancedFieldSelector>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldSelectors(List<AdvancedFieldSelector>)}.
         * 
         * @param fieldSelectors
         *        a consumer that will call methods on {@link List<AdvancedFieldSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldSelectors(List<AdvancedFieldSelector>)
         */
        Builder fieldSelectors(Consumer<AdvancedFieldSelector.Builder>... fieldSelectors);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<AdvancedFieldSelector> fieldSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedEventSelector model) {
            name(model.name);
            fieldSelectors(model.fieldSelectors);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<AdvancedFieldSelector.Builder> getFieldSelectors() {
            if (fieldSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldSelectors != null ? fieldSelectors.stream().map(AdvancedFieldSelector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldSelectors(Collection<AdvancedFieldSelector> fieldSelectors) {
            this.fieldSelectors = AdvancedFieldSelectorsCopier.copy(fieldSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldSelectors(AdvancedFieldSelector... fieldSelectors) {
            fieldSelectors(Arrays.asList(fieldSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldSelectors(Consumer<AdvancedFieldSelector.Builder>... fieldSelectors) {
            fieldSelectors(Stream.of(fieldSelectors).map(c -> AdvancedFieldSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldSelectors(Collection<AdvancedFieldSelector.BuilderImpl> fieldSelectors) {
            this.fieldSelectors = AdvancedFieldSelectorsCopier.copyFromBuilder(fieldSelectors);
        }

        @Override
        public AdvancedEventSelector build() {
            return new AdvancedEventSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
