/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.InsightType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightSelector> {
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InsightSelector.getter(InsightSelector::insightTypeAsString)).setter(InsightSelector.setter(Builder::insightType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String insightType;

    private InsightSelector(BuilderImpl builder) {
        this.insightType = builder.insightType;
    }

    public InsightType insightType() {
        return InsightType.fromValue(this.insightType);
    }

    public String insightTypeAsString() {
        return this.insightType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightSelector)) {
            return false;
        }
        InsightSelector other = (InsightSelector)obj;
        return Objects.equals(this.insightTypeAsString(), other.insightTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"InsightSelector").add("InsightType", (Object)this.insightTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightType": {
                return Optional.ofNullable(clazz.cast(this.insightTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightSelector, T> g) {
        return obj -> g.apply((InsightSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightType;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightSelector model) {
            this.insightType(model.insightType);
        }

        public final String getInsightType() {
            return this.insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        public InsightSelector build() {
            return new InsightSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightSelector> {
        public Builder insightType(String var1);

        public Builder insightType(InsightType var1);
    }
}

