/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInsightSelectorsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<PutInsightSelectorsRequest.Builder, PutInsightSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInsightSelectorsRequest::trailName)).setter(setter(Builder::trailName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()).build();

    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField
            .<List<InsightSelector>> builder(MarshallingType.LIST)
            .getter(getter(PutInsightSelectorsRequest::insightSelectors))
            .setter(setter(Builder::insightSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD,
            INSIGHT_SELECTORS_FIELD));

    private final String trailName;

    private final List<InsightSelector> insightSelectors;

    private PutInsightSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.insightSelectors = builder.insightSelectors;
    }

    /**
     * <p>
     * The name of the CloudTrail trail for which you want to change or add Insights selectors.
     * </p>
     * 
     * @return The name of the CloudTrail trail for which you want to change or add Insights selectors.
     */
    public String trailName() {
        return trailName;
    }

    /**
     * Returns true if the InsightSelectors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInsightSelectors() {
        return insightSelectors != null && !(insightSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON string that contains the insight types you want to log on a trail. In this release, only
     * <code>ApiCallRateInsight</code> is supported as an insight type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInsightSelectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON string that contains the insight types you want to log on a trail. In this release, only
     *         <code>ApiCallRateInsight</code> is supported as an insight type.
     */
    public List<InsightSelector> insightSelectors() {
        return insightSelectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailName());
        hashCode = 31 * hashCode + Objects.hashCode(insightSelectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsRequest)) {
            return false;
        }
        PutInsightSelectorsRequest other = (PutInsightSelectorsRequest) obj;
        return Objects.equals(trailName(), other.trailName()) && Objects.equals(insightSelectors(), other.insightSelectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutInsightSelectorsRequest").add("TrailName", trailName())
                .add("InsightSelectors", insightSelectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailName":
            return Optional.ofNullable(clazz.cast(trailName()));
        case "InsightSelectors":
            return Optional.ofNullable(clazz.cast(insightSelectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightSelectorsRequest, T> g) {
        return obj -> g.apply((PutInsightSelectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutInsightSelectorsRequest> {
        /**
         * <p>
         * The name of the CloudTrail trail for which you want to change or add Insights selectors.
         * </p>
         * 
         * @param trailName
         *        The name of the CloudTrail trail for which you want to change or add Insights selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailName(String trailName);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release, only
         * <code>ApiCallRateInsight</code> is supported as an insight type.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the insight types you want to log on a trail. In this release, only
         *        <code>ApiCallRateInsight</code> is supported as an insight type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(Collection<InsightSelector> insightSelectors);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release, only
         * <code>ApiCallRateInsight</code> is supported as an insight type.
         * </p>
         * 
         * @param insightSelectors
         *        A JSON string that contains the insight types you want to log on a trail. In this release, only
         *        <code>ApiCallRateInsight</code> is supported as an insight type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightSelectors(InsightSelector... insightSelectors);

        /**
         * <p>
         * A JSON string that contains the insight types you want to log on a trail. In this release, only
         * <code>ApiCallRateInsight</code> is supported as an insight type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InsightSelector>.Builder} avoiding the need
         * to create one manually via {@link List<InsightSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #insightSelectors(List<InsightSelector>)}.
         * 
         * @param insightSelectors
         *        a consumer that will call methods on {@link List<InsightSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightSelectors(List<InsightSelector>)
         */
        Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String trailName;

        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightSelectorsRequest model) {
            super(model);
            trailName(model.trailName);
            insightSelectors(model.insightSelectors);
        }

        public final String getTrailName() {
            return trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        public final Collection<InsightSelector.Builder> getInsightSelectors() {
            return insightSelectors != null ? insightSelectors.stream().map(InsightSelector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector... insightSelectors) {
            insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder>... insightSelectors) {
            insightSelectors(Stream.of(insightSelectors).map(c -> InsightSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightSelectorsRequest build() {
            return new PutInsightSelectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
