/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarning;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceWarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadDocumentsResponse
extends CloudSearchDomainResponse
implements ToCopyableBuilder<Builder, UploadDocumentsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UploadDocumentsResponse.getter(UploadDocumentsResponse::status)).setter(UploadDocumentsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Long> ADDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("adds").getter(UploadDocumentsResponse.getter(UploadDocumentsResponse::adds)).setter(UploadDocumentsResponse.setter(Builder::adds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adds").build()}).build();
    private static final SdkField<Long> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("deletes").getter(UploadDocumentsResponse.getter(UploadDocumentsResponse::deletes)).setter(UploadDocumentsResponse.setter(Builder::deletes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()}).build();
    private static final SdkField<List<DocumentServiceWarning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("warnings").getter(UploadDocumentsResponse.getter(UploadDocumentsResponse::warnings)).setter(UploadDocumentsResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentServiceWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ADDS_FIELD, DELETES_FIELD, WARNINGS_FIELD));
    private final String status;
    private final Long adds;
    private final Long deletes;
    private final List<DocumentServiceWarning> warnings;

    private UploadDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.adds = builder.adds;
        this.deletes = builder.deletes;
        this.warnings = builder.warnings;
    }

    public String status() {
        return this.status;
    }

    public Long adds() {
        return this.adds;
    }

    public Long deletes() {
        return this.deletes;
    }

    public boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public List<DocumentServiceWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.adds());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResponse)) {
            return false;
        }
        UploadDocumentsResponse other = (UploadDocumentsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.adds(), other.adds()) && Objects.equals(this.deletes(), other.deletes()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public String toString() {
        return ToString.builder((String)"UploadDocumentsResponse").add("Status", (Object)this.status()).add("Adds", (Object)this.adds()).add("Deletes", (Object)this.deletes()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "adds": {
                return Optional.ofNullable(clazz.cast(this.adds()));
            }
            case "deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadDocumentsResponse, T> g) {
        return obj -> g.apply((UploadDocumentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchDomainResponse.BuilderImpl
    implements Builder {
        private String status;
        private Long adds;
        private Long deletes;
        private List<DocumentServiceWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsResponse model) {
            super(model);
            this.status(model.status);
            this.adds(model.adds);
            this.deletes(model.deletes);
            this.warnings(model.warnings);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getAdds() {
            return this.adds;
        }

        @Override
        public final Builder adds(Long adds) {
            this.adds = adds;
            return this;
        }

        public final void setAdds(Long adds) {
            this.adds = adds;
        }

        public final Long getDeletes() {
            return this.deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Collection<DocumentServiceWarning.Builder> getWarnings() {
            if (this.warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.warnings != null ? (Collection)this.warnings.stream().map(DocumentServiceWarning::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder warnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(DocumentServiceWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<DocumentServiceWarning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (DocumentServiceWarning)((DocumentServiceWarning.Builder)DocumentServiceWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<DocumentServiceWarning.BuilderImpl> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public UploadDocumentsResponse build() {
            return new UploadDocumentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchDomainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UploadDocumentsResponse> {
        public Builder status(String var1);

        public Builder adds(Long var1);

        public Builder deletes(Long var1);

        public Builder warnings(Collection<DocumentServiceWarning> var1);

        public Builder warnings(DocumentServiceWarning ... var1);

        public Builder warnings(Consumer<DocumentServiceWarning.Builder> ... var1);
    }
}

