/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SuggestionMatchMarshaller {
    private static final MarshallingInfo<String> SUGGESTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suggestion").isBinary(false).build();
    private static final MarshallingInfo<Long> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("score").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final SuggestionMatchMarshaller INSTANCE = new SuggestionMatchMarshaller();

    private SuggestionMatchMarshaller() {
    }

    public static SuggestionMatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SuggestionMatch suggestionMatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)suggestionMatch, (String)"suggestionMatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)suggestionMatch.suggestion(), SUGGESTION_BINDING);
            protocolMarshaller.marshall((Object)suggestionMatch.score(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)suggestionMatch.id(), ID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

