/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hit;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HitMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<Map> FIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fields").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exprs").isBinary(false).build();
    private static final MarshallingInfo<Map> HIGHLIGHTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("highlights").isBinary(false).build();
    private static final HitMarshaller INSTANCE = new HitMarshaller();

    private HitMarshaller() {
    }

    public static HitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Hit hit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hit, (String)"hit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hit.id(), ID_BINDING);
            protocolMarshaller.marshall(hit.fields(), FIELDS_BINDING);
            protocolMarshaller.marshall(hit.exprs(), EXPRS_BINDING);
            protocolMarshaller.marshall(hit.highlights(), HIGHLIGHTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

