/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hit;
import software.amazon.awssdk.services.cloudsearchdomain.model.HitListCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.HitsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hits
implements StructuredPojo,
ToCopyableBuilder<Builder, Hits> {
    private final Long found;
    private final Long start;
    private final String cursor;
    private final List<Hit> hit;

    private Hits(BuilderImpl builder) {
        this.found = builder.found;
        this.start = builder.start;
        this.cursor = builder.cursor;
        this.hit = builder.hit;
    }

    public Long found() {
        return this.found;
    }

    public Long start() {
        return this.start;
    }

    public String cursor() {
        return this.cursor;
    }

    public List<Hit> hit() {
        return this.hit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.found());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.cursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hits)) {
            return false;
        }
        Hits other = (Hits)obj;
        return Objects.equals(this.found(), other.found()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.cursor(), other.cursor()) && Objects.equals(this.hit(), other.hit());
    }

    public String toString() {
        return ToString.builder((String)"Hits").add("Found", (Object)this.found()).add("Start", (Object)this.start()).add("Cursor", (Object)this.cursor()).add("Hit", this.hit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "found": {
                return Optional.ofNullable(clazz.cast(this.found()));
            }
            case "start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "cursor": {
                return Optional.ofNullable(clazz.cast(this.cursor()));
            }
            case "hit": {
                return Optional.ofNullable(clazz.cast(this.hit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long found;
        private Long start;
        private String cursor;
        private List<Hit> hit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hits model) {
            this.found(model.found);
            this.start(model.start);
            this.cursor(model.cursor);
            this.hit(model.hit);
        }

        public final Long getFound() {
            return this.found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final Long getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final String getCursor() {
            return this.cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public final Collection<Hit.Builder> getHit() {
            return this.hit != null ? (Collection)this.hit.stream().map(Hit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Hit ... hit) {
            this.hit(Arrays.asList(hit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Consumer<Hit.Builder> ... hit) {
            this.hit(Stream.of(hit).map(c -> (Hit)((Hit.Builder)Hit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHit(Collection<Hit.BuilderImpl> hit) {
            this.hit = HitListCopier.copyFromBuilder(hit);
        }

        public Hits build() {
            return new Hits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Hits> {
        public Builder found(Long var1);

        public Builder start(Long var1);

        public Builder cursor(String var1);

        public Builder hit(Collection<Hit> var1);

        public Builder hit(Hit ... var1);

        public Builder hit(Consumer<Hit.Builder> ... var1);
    }
}

