/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(TextOptions.getter(TextOptions::defaultValue)).setter(TextOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceField").getter(TextOptions.getter(TextOptions::sourceField)).setter(TextOptions.setter(Builder::sourceField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()}).build();
    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnEnabled").getter(TextOptions.getter(TextOptions::returnEnabled)).setter(TextOptions.setter(Builder::returnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()}).build();
    private static final SdkField<Boolean> SORT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SortEnabled").getter(TextOptions.getter(TextOptions::sortEnabled)).setter(TextOptions.setter(Builder::sortEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortEnabled").build()}).build();
    private static final SdkField<Boolean> HIGHLIGHT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HighlightEnabled").getter(TextOptions.getter(TextOptions::highlightEnabled)).setter(TextOptions.setter(Builder::highlightEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighlightEnabled").build()}).build();
    private static final SdkField<String> ANALYSIS_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisScheme").getter(TextOptions.getter(TextOptions::analysisScheme)).setter(TextOptions.setter(Builder::analysisScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisScheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, SOURCE_FIELD_FIELD, RETURN_ENABLED_FIELD, SORT_ENABLED_FIELD, HIGHLIGHT_ENABLED_FIELD, ANALYSIS_SCHEME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String sourceField;
    private final Boolean returnEnabled;
    private final Boolean sortEnabled;
    private final Boolean highlightEnabled;
    private final String analysisScheme;

    private TextOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String sourceField() {
        return this.sourceField;
    }

    public final Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public final Boolean sortEnabled() {
        return this.sortEnabled;
    }

    public final Boolean highlightEnabled() {
        return this.highlightEnabled;
    }

    public final String analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlightEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisScheme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextOptions)) {
            return false;
        }
        TextOptions other = (TextOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.returnEnabled(), other.returnEnabled()) && Objects.equals(this.sortEnabled(), other.sortEnabled()) && Objects.equals(this.highlightEnabled(), other.highlightEnabled()) && Objects.equals(this.analysisScheme(), other.analysisScheme());
    }

    public final String toString() {
        return ToString.builder((String)"TextOptions").add("DefaultValue", (Object)this.defaultValue()).add("SourceField", (Object)this.sourceField()).add("ReturnEnabled", (Object)this.returnEnabled()).add("SortEnabled", (Object)this.sortEnabled()).add("HighlightEnabled", (Object)this.highlightEnabled()).add("AnalysisScheme", (Object)this.analysisScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SourceField": {
                return Optional.ofNullable(clazz.cast(this.sourceField()));
            }
            case "ReturnEnabled": {
                return Optional.ofNullable(clazz.cast(this.returnEnabled()));
            }
            case "SortEnabled": {
                return Optional.ofNullable(clazz.cast(this.sortEnabled()));
            }
            case "HighlightEnabled": {
                return Optional.ofNullable(clazz.cast(this.highlightEnabled()));
            }
            case "AnalysisScheme": {
                return Optional.ofNullable(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("SourceField", SOURCE_FIELD_FIELD);
        map.put("ReturnEnabled", RETURN_ENABLED_FIELD);
        map.put("SortEnabled", SORT_ENABLED_FIELD);
        map.put("HighlightEnabled", HIGHLIGHT_ENABLED_FIELD);
        map.put("AnalysisScheme", ANALYSIS_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextOptions, T> g) {
        return obj -> g.apply((TextOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceField;
        private Boolean returnEnabled;
        private Boolean sortEnabled;
        private Boolean highlightEnabled;
        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceField(model.sourceField);
            this.returnEnabled(model.returnEnabled);
            this.sortEnabled(model.sortEnabled);
            this.highlightEnabled(model.highlightEnabled);
            this.analysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final Boolean getSortEnabled() {
            return this.sortEnabled;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final Boolean getHighlightEnabled() {
            return this.highlightEnabled;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final String getAnalysisScheme() {
            return this.analysisScheme;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public TextOptions build() {
            return new TextOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceField(String var1);

        public Builder returnEnabled(Boolean var1);

        public Builder sortEnabled(Boolean var1);

        public Builder highlightEnabled(Boolean var1);

        public Builder analysisScheme(String var1);
    }
}

