/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndexFieldType {
    INT("int"),
    DOUBLE("double"),
    LITERAL("literal"),
    TEXT("text"),
    DATE("date"),
    LATLON("latlon"),
    INT_ARRAY("int-array"),
    DOUBLE_ARRAY("double-array"),
    LITERAL_ARRAY("literal-array"),
    TEXT_ARRAY("text-array"),
    DATE_ARRAY("date-array"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndexFieldType> VALUE_MAP;
    private final String value;

    private IndexFieldType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexFieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndexFieldType> knownValues() {
        EnumSet<IndexFieldType> knownValues = EnumSet.allOf(IndexFieldType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndexFieldType.class, IndexFieldType::toString);
    }
}

