/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.Expression;
import software.amazon.awssdk.services.cloudsearch.model.OptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressionStatus> {
    private static final SdkField<Expression> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(ExpressionStatus.getter(ExpressionStatus::options)).setter(ExpressionStatus.setter(Builder::options)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ExpressionStatus.getter(ExpressionStatus::status)).setter(ExpressionStatus.setter(Builder::status)).constructor(OptionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Options", OPTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Expression options;
    private final OptionStatus status;

    private ExpressionStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public final Expression options() {
        return this.options;
    }

    public final OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressionStatus)) {
            return false;
        }
        ExpressionStatus other = (ExpressionStatus)obj;
        return Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressionStatus").add("Options", (Object)this.options()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExpressionStatus, T> g) {
        return obj -> g.apply((ExpressionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Expression options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressionStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final Expression.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Expression.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Expression options) {
            this.options = options;
            return this;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public ExpressionStatus build() {
            return new ExpressionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressionStatus> {
        public Builder options(Expression var1);

        default public Builder options(Consumer<Expression.Builder> options) {
            return this.options((Expression)((Expression.Builder)Expression.builder().applyMutation(options)).build());
        }

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().applyMutation(status)).build());
        }
    }
}

