/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScalingParametersRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, UpdateScalingParametersRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateScalingParametersRequest.getter(UpdateScalingParametersRequest::domainName)).setter(UpdateScalingParametersRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<ScalingParameters> SCALING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingParameters").getter(UpdateScalingParametersRequest.getter(UpdateScalingParametersRequest::scalingParameters)).setter(UpdateScalingParametersRequest.setter(Builder::scalingParameters)).constructor(ScalingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SCALING_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ScalingParameters", SCALING_PARAMETERS_FIELD);
        }
    });
    private final String domainName;
    private final ScalingParameters scalingParameters;

    private UpdateScalingParametersRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.scalingParameters = builder.scalingParameters;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ScalingParameters scalingParameters() {
        return this.scalingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingParametersRequest)) {
            return false;
        }
        UpdateScalingParametersRequest other = (UpdateScalingParametersRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.scalingParameters(), other.scalingParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScalingParametersRequest").add("DomainName", (Object)this.domainName()).add("ScalingParameters", (Object)this.scalingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ScalingParameters": {
                return Optional.ofNullable(clazz.cast(this.scalingParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScalingParametersRequest, T> g) {
        return obj -> g.apply((UpdateScalingParametersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private ScalingParameters scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingParametersRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.scalingParameters(model.scalingParameters);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ScalingParameters.Builder getScalingParameters() {
            return this.scalingParameters != null ? this.scalingParameters.toBuilder() : null;
        }

        public final void setScalingParameters(ScalingParameters.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        public final Builder scalingParameters(ScalingParameters scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScalingParametersRequest build() {
            return new UpdateScalingParametersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScalingParametersRequest> {
        public Builder domainName(String var1);

        public Builder scalingParameters(ScalingParameters var1);

        default public Builder scalingParameters(Consumer<ScalingParameters.Builder> scalingParameters) {
            return this.scalingParameters((ScalingParameters)((ScalingParameters.Builder)ScalingParameters.builder().applyMutation(scalingParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

