/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudsearch.CloudSearchAsyncClient;
import software.amazon.awssdk.services.cloudsearch.CloudSearchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudsearch.CloudSearchServiceClientConfiguration;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchAsyncClient;
import software.amazon.awssdk.services.cloudsearch.DefaultCloudSearchBaseClientBuilder;
import software.amazon.awssdk.services.cloudsearch.endpoints.CloudSearchEndpointProvider;

@SdkInternalApi
final class DefaultCloudSearchAsyncClientBuilder
extends DefaultCloudSearchBaseClientBuilder<CloudSearchAsyncClientBuilder, CloudSearchAsyncClient>
implements CloudSearchAsyncClientBuilder {
    DefaultCloudSearchAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudSearchAsyncClientBuilder endpointProvider(CloudSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudSearchAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudSearchAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudSearchServiceClientConfiguration serviceClientConfiguration = CloudSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudSearchAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

