/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DoubleOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DoubleOptions> {
    private static final SdkField<Double> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DefaultValue").getter(DoubleOptions.getter(DoubleOptions::defaultValue)).setter(DoubleOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceField").getter(DoubleOptions.getter(DoubleOptions::sourceField)).setter(DoubleOptions.setter(Builder::sourceField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()}).build();
    private static final SdkField<Boolean> FACET_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FacetEnabled").getter(DoubleOptions.getter(DoubleOptions::facetEnabled)).setter(DoubleOptions.setter(Builder::facetEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetEnabled").build()}).build();
    private static final SdkField<Boolean> SEARCH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SearchEnabled").getter(DoubleOptions.getter(DoubleOptions::searchEnabled)).setter(DoubleOptions.setter(Builder::searchEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchEnabled").build()}).build();
    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnEnabled").getter(DoubleOptions.getter(DoubleOptions::returnEnabled)).setter(DoubleOptions.setter(Builder::returnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()}).build();
    private static final SdkField<Boolean> SORT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SortEnabled").getter(DoubleOptions.getter(DoubleOptions::sortEnabled)).setter(DoubleOptions.setter(Builder::sortEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, SOURCE_FIELD_FIELD, FACET_ENABLED_FIELD, SEARCH_ENABLED_FIELD, RETURN_ENABLED_FIELD, SORT_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double defaultValue;
    private final String sourceField;
    private final Boolean facetEnabled;
    private final Boolean searchEnabled;
    private final Boolean returnEnabled;
    private final Boolean sortEnabled;

    private DoubleOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
    }

    public Double defaultValue() {
        return this.defaultValue;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public Boolean facetEnabled() {
        return this.facetEnabled;
    }

    public Boolean searchEnabled() {
        return this.searchEnabled;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Boolean sortEnabled() {
        return this.sortEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleOptions)) {
            return false;
        }
        DoubleOptions other = (DoubleOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.facetEnabled(), other.facetEnabled()) && Objects.equals(this.searchEnabled(), other.searchEnabled()) && Objects.equals(this.returnEnabled(), other.returnEnabled()) && Objects.equals(this.sortEnabled(), other.sortEnabled());
    }

    public String toString() {
        return ToString.builder((String)"DoubleOptions").add("DefaultValue", (Object)this.defaultValue()).add("SourceField", (Object)this.sourceField()).add("FacetEnabled", (Object)this.facetEnabled()).add("SearchEnabled", (Object)this.searchEnabled()).add("ReturnEnabled", (Object)this.returnEnabled()).add("SortEnabled", (Object)this.sortEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SourceField": {
                return Optional.ofNullable(clazz.cast(this.sourceField()));
            }
            case "FacetEnabled": {
                return Optional.ofNullable(clazz.cast(this.facetEnabled()));
            }
            case "SearchEnabled": {
                return Optional.ofNullable(clazz.cast(this.searchEnabled()));
            }
            case "ReturnEnabled": {
                return Optional.ofNullable(clazz.cast(this.returnEnabled()));
            }
            case "SortEnabled": {
                return Optional.ofNullable(clazz.cast(this.sortEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DoubleOptions, T> g) {
        return obj -> g.apply((DoubleOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double defaultValue;
        private String sourceField;
        private Boolean facetEnabled;
        private Boolean searchEnabled;
        private Boolean returnEnabled;
        private Boolean sortEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DoubleOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceField(model.sourceField);
            this.facetEnabled(model.facetEnabled);
            this.searchEnabled(model.searchEnabled);
            this.returnEnabled(model.returnEnabled);
            this.sortEnabled(model.sortEnabled);
        }

        public final Double getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final Boolean getFacetEnabled() {
            return this.facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        public final Boolean getSearchEnabled() {
            return this.searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getSortEnabled() {
            return this.sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        public DoubleOptions build() {
            return new DoubleOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DoubleOptions> {
        public Builder defaultValue(Double var1);

        public Builder sourceField(String var1);

        public Builder facetEnabled(Boolean var1);

        public Builder searchEnabled(Boolean var1);

        public Builder returnEnabled(Boolean var1);

        public Builder sortEnabled(Boolean var1);
    }
}

