/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Limits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Limits> {
    private static final SdkField<Integer> MAXIMUM_REPLICATION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumReplicationCount").getter(Limits.getter(Limits::maximumReplicationCount)).setter(Limits.setter(Builder::maximumReplicationCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumReplicationCount").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PARTITION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPartitionCount").getter(Limits.getter(Limits::maximumPartitionCount)).setter(Limits.setter(Builder::maximumPartitionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPartitionCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_REPLICATION_COUNT_FIELD, MAXIMUM_PARTITION_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumReplicationCount;
    private final Integer maximumPartitionCount;

    private Limits(BuilderImpl builder) {
        this.maximumReplicationCount = builder.maximumReplicationCount;
        this.maximumPartitionCount = builder.maximumPartitionCount;
    }

    public Integer maximumReplicationCount() {
        return this.maximumReplicationCount;
    }

    public Integer maximumPartitionCount() {
        return this.maximumPartitionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumReplicationCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPartitionCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits)obj;
        return Objects.equals(this.maximumReplicationCount(), other.maximumReplicationCount()) && Objects.equals(this.maximumPartitionCount(), other.maximumPartitionCount());
    }

    public String toString() {
        return ToString.builder((String)"Limits").add("MaximumReplicationCount", (Object)this.maximumReplicationCount()).add("MaximumPartitionCount", (Object)this.maximumPartitionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumReplicationCount": {
                return Optional.ofNullable(clazz.cast(this.maximumReplicationCount()));
            }
            case "MaximumPartitionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPartitionCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Limits, T> g) {
        return obj -> g.apply((Limits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumReplicationCount;
        private Integer maximumPartitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Limits model) {
            this.maximumReplicationCount(model.maximumReplicationCount);
            this.maximumPartitionCount(model.maximumPartitionCount);
        }

        public final Integer getMaximumReplicationCount() {
            return this.maximumReplicationCount;
        }

        @Override
        public final Builder maximumReplicationCount(Integer maximumReplicationCount) {
            this.maximumReplicationCount = maximumReplicationCount;
            return this;
        }

        public final void setMaximumReplicationCount(Integer maximumReplicationCount) {
            this.maximumReplicationCount = maximumReplicationCount;
        }

        public final Integer getMaximumPartitionCount() {
            return this.maximumPartitionCount;
        }

        @Override
        public final Builder maximumPartitionCount(Integer maximumPartitionCount) {
            this.maximumPartitionCount = maximumPartitionCount;
            return this;
        }

        public final void setMaximumPartitionCount(Integer maximumPartitionCount) {
            this.maximumPartitionCount = maximumPartitionCount;
        }

        public Limits build() {
            return new Limits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Limits> {
        public Builder maximumReplicationCount(Integer var1);

        public Builder maximumPartitionCount(Integer var1);
    }
}

