/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AnalysisSchemeLanguage {
    AR("ar"),
    BG("bg"),
    CA("ca"),
    CS("cs"),
    DA("da"),
    DE("de"),
    EL("el"),
    EN("en"),
    ES("es"),
    EU("eu"),
    FA("fa"),
    FI("fi"),
    FR("fr"),
    GA("ga"),
    GL("gl"),
    HE("he"),
    HI("hi"),
    HU("hu"),
    HY("hy"),
    ID("id"),
    IT("it"),
    JA("ja"),
    KO("ko"),
    LV("lv"),
    MUL("mul"),
    NL("nl"),
    NO("no"),
    PT("pt"),
    RO("ro"),
    RU("ru"),
    SV("sv"),
    TH("th"),
    TR("tr"),
    ZH_HANS("zh-Hans"),
    ZH_HANT("zh-Hant"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AnalysisSchemeLanguage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisSchemeLanguage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AnalysisSchemeLanguage.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisSchemeLanguage> knownValues() {
        return Stream.of(AnalysisSchemeLanguage.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

