/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisScheme
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisScheme> {
    private static final SdkField<String> ANALYSIS_SCHEME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisScheme.getter(AnalysisScheme::analysisSchemeName)).setter(AnalysisScheme.setter(Builder::analysisSchemeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeName").build()}).build();
    private static final SdkField<String> ANALYSIS_SCHEME_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AnalysisScheme.getter(AnalysisScheme::analysisSchemeLanguageAsString)).setter(AnalysisScheme.setter(Builder::analysisSchemeLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeLanguage").build()}).build();
    private static final SdkField<AnalysisOptions> ANALYSIS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AnalysisScheme.getter(AnalysisScheme::analysisOptions)).setter(AnalysisScheme.setter(Builder::analysisOptions)).constructor(AnalysisOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEME_NAME_FIELD, ANALYSIS_SCHEME_LANGUAGE_FIELD, ANALYSIS_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String analysisSchemeName;
    private final String analysisSchemeLanguage;
    private final AnalysisOptions analysisOptions;

    private AnalysisScheme(BuilderImpl builder) {
        this.analysisSchemeName = builder.analysisSchemeName;
        this.analysisSchemeLanguage = builder.analysisSchemeLanguage;
        this.analysisOptions = builder.analysisOptions;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    public AnalysisSchemeLanguage analysisSchemeLanguage() {
        return AnalysisSchemeLanguage.fromValue(this.analysisSchemeLanguage);
    }

    public String analysisSchemeLanguageAsString() {
        return this.analysisSchemeLanguage;
    }

    public AnalysisOptions analysisOptions() {
        return this.analysisOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisScheme)) {
            return false;
        }
        AnalysisScheme other = (AnalysisScheme)obj;
        return Objects.equals(this.analysisSchemeName(), other.analysisSchemeName()) && Objects.equals(this.analysisSchemeLanguageAsString(), other.analysisSchemeLanguageAsString()) && Objects.equals(this.analysisOptions(), other.analysisOptions());
    }

    public String toString() {
        return ToString.builder((String)"AnalysisScheme").add("AnalysisSchemeName", (Object)this.analysisSchemeName()).add("AnalysisSchemeLanguage", (Object)this.analysisSchemeLanguageAsString()).add("AnalysisOptions", (Object)this.analysisOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSchemeName": {
                return Optional.ofNullable(clazz.cast(this.analysisSchemeName()));
            }
            case "AnalysisSchemeLanguage": {
                return Optional.ofNullable(clazz.cast(this.analysisSchemeLanguageAsString()));
            }
            case "AnalysisOptions": {
                return Optional.ofNullable(clazz.cast(this.analysisOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisScheme, T> g) {
        return obj -> g.apply((AnalysisScheme)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisSchemeName;
        private String analysisSchemeLanguage;
        private AnalysisOptions analysisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisScheme model) {
            this.analysisSchemeName(model.analysisSchemeName);
            this.analysisSchemeLanguage(model.analysisSchemeLanguage);
            this.analysisOptions(model.analysisOptions);
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public final String getAnalysisSchemeLanguage() {
            return this.analysisSchemeLanguage;
        }

        @Override
        public final Builder analysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
            return this;
        }

        @Override
        public final Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage == null ? null : analysisSchemeLanguage.toString());
            return this;
        }

        public final void setAnalysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
        }

        public final AnalysisOptions.Builder getAnalysisOptions() {
            return this.analysisOptions != null ? this.analysisOptions.toBuilder() : null;
        }

        @Override
        public final Builder analysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
            return this;
        }

        public final void setAnalysisOptions(AnalysisOptions.BuilderImpl analysisOptions) {
            this.analysisOptions = analysisOptions != null ? analysisOptions.build() : null;
        }

        public AnalysisScheme build() {
            return new AnalysisScheme(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisScheme> {
        public Builder analysisSchemeName(String var1);

        public Builder analysisSchemeLanguage(String var1);

        public Builder analysisSchemeLanguage(AnalysisSchemeLanguage var1);

        public Builder analysisOptions(AnalysisOptions var1);

        default public Builder analysisOptions(Consumer<AnalysisOptions.Builder> analysisOptions) {
            return this.analysisOptions((AnalysisOptions)((AnalysisOptions.Builder)AnalysisOptions.builder().applyMutation(analysisOptions)).build());
        }
    }
}

