/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAnalysisSchemeRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DeleteAnalysisSchemeRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteAnalysisSchemeRequest.getter(DeleteAnalysisSchemeRequest::domainName)).setter(DeleteAnalysisSchemeRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ANALYSIS_SCHEME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteAnalysisSchemeRequest.getter(DeleteAnalysisSchemeRequest::analysisSchemeName)).setter(DeleteAnalysisSchemeRequest.setter(Builder::analysisSchemeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ANALYSIS_SCHEME_NAME_FIELD));
    private final String domainName;
    private final String analysisSchemeName;

    private DeleteAnalysisSchemeRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.analysisSchemeName = builder.analysisSchemeName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisSchemeRequest)) {
            return false;
        }
        DeleteAnalysisSchemeRequest other = (DeleteAnalysisSchemeRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.analysisSchemeName(), other.analysisSchemeName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAnalysisSchemeRequest").add("DomainName", (Object)this.domainName()).add("AnalysisSchemeName", (Object)this.analysisSchemeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AnalysisSchemeName": {
                return Optional.ofNullable(clazz.cast(this.analysisSchemeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalysisSchemeRequest, T> g) {
        return obj -> g.apply((DeleteAnalysisSchemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String analysisSchemeName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisSchemeRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.analysisSchemeName(model.analysisSchemeName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAnalysisSchemeRequest build() {
            return new DeleteAnalysisSchemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAnalysisSchemeRequest> {
        public Builder domainName(String var1);

        public Builder analysisSchemeName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

