/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SuggestModelMarshaller {
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("query").isBinary(false).build();
    private static final MarshallingInfo<Long> FOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("found").isBinary(false).build();
    private static final MarshallingInfo<List> SUGGESTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suggestions").isBinary(false).build();
    private static final SuggestModelMarshaller INSTANCE = new SuggestModelMarshaller();

    private SuggestModelMarshaller() {
    }

    public static SuggestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SuggestModel suggestModel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)suggestModel, (String)"suggestModel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)suggestModel.query(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)suggestModel.found(), FOUND_BINDING);
            protocolMarshaller.marshall(suggestModel.suggestions(), SUGGESTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

