/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.model.Bucket;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketListCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.BucketInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BucketInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, BucketInfo> {
    private final List<Bucket> buckets;

    private BucketInfo(BuilderImpl builder) {
        this.buckets = builder.buckets;
    }

    public List<Bucket> buckets() {
        return this.buckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.buckets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo other = (BucketInfo)obj;
        return Objects.equals(this.buckets(), other.buckets());
    }

    public String toString() {
        return ToString.builder((String)"BucketInfo").add("Buckets", this.buckets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buckets": {
                return Optional.of(clazz.cast(this.buckets()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BucketInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Bucket> buckets;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketInfo model) {
            this.buckets(model.buckets);
        }

        public final Collection<Bucket.Builder> getBuckets() {
            return this.buckets != null ? (Collection)this.buckets.stream().map(Bucket::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketListCopier.copyFromBuilder(buckets);
        }

        public BucketInfo build() {
            return new BucketInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BucketInfo> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);
    }
}

