/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.Expression;

public class ExpressionUnmarshaller
implements Unmarshaller<Expression, StaxUnmarshallerContext> {
    private static final ExpressionUnmarshaller INSTANCE = new ExpressionUnmarshaller();

    public Expression unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Expression.Builder expression = Expression.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ExpressionName", targetDepth)) {
                    expression.expressionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ExpressionValue", targetDepth)) continue;
                expression.expressionValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Expression)expression.build();
    }

    public static ExpressionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

