/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateServiceAccessPoliciesRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, UpdateServiceAccessPoliciesRequest> {
    private final String domainName;
    private final String accessPolicies;

    private UpdateServiceAccessPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.accessPolicies = builder.accessPolicies;
    }

    public String domainName() {
        return this.domainName;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceAccessPoliciesRequest)) {
            return false;
        }
        UpdateServiceAccessPoliciesRequest other = (UpdateServiceAccessPoliciesRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.accessPolicies(), other.accessPolicies());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServiceAccessPoliciesRequest").add("DomainName", (Object)this.domainName()).add("AccessPolicies", (Object)this.accessPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AccessPolicies": {
                return Optional.of(clazz.cast(this.accessPolicies()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String accessPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceAccessPoliciesRequest model) {
            this.domainName(model.domainName);
            this.accessPolicies(model.accessPolicies);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceAccessPoliciesRequest build() {
            return new UpdateServiceAccessPoliciesRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, UpdateServiceAccessPoliciesRequest> {
        public Builder domainName(String var1);

        public Builder accessPolicies(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

