/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncRequestProvider;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainAsyncClient;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainException;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SearchResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestResponseUnmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.UploadDocumentsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.transform.UploadDocumentsResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloudSearchDomainAsyncClient
implements CloudSearchDomainAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultCloudSearchDomainAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<SearchResponse> search(SearchRequest searchRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SearchRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchRequest));
    }

    @Override
    public CompletableFuture<SuggestResponse> suggest(SuggestRequest suggestRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SuggestResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SuggestRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)suggestRequest));
    }

    @Override
    public CompletableFuture<UploadDocumentsResponse> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, AsyncRequestProvider requestProvider) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadDocumentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UploadDocumentsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withAsyncRequestProvider(requestProvider).withInput((SdkRequest)uploadDocumentsRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CloudSearchDomainException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SearchException").withModeledClass(SearchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DocumentServiceException").withModeledClass(DocumentServiceException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

