/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus;
import software.amazon.awssdk.services.cloudsearch.transform.IndexFieldUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.OptionStatusUnmarshaller;

public class IndexFieldStatusUnmarshaller
implements Unmarshaller<IndexFieldStatus, StaxUnmarshallerContext> {
    private static final IndexFieldStatusUnmarshaller INSTANCE = new IndexFieldStatusUnmarshaller();

    public IndexFieldStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IndexFieldStatus.Builder indexFieldStatus = IndexFieldStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Options", targetDepth)) {
                    indexFieldStatus.options(IndexFieldUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                indexFieldStatus.status(OptionStatusUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IndexFieldStatus)indexFieldStatus.build();
    }

    public static IndexFieldStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}

