/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAvailabilityOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAvailabilityOptionsRequest> {
    private final String domainName;
    private final Boolean deployed;

    private DescribeAvailabilityOptionsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.deployed = builder.deployed;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityOptionsRequest)) {
            return false;
        }
        DescribeAvailabilityOptionsRequest other = (DescribeAvailabilityOptionsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.deployed(), other.deployed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Deployed": {
                return Optional.of(clazz.cast(this.deployed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityOptionsRequest model) {
            this.domainName(model.domainName);
            this.deployed(model.deployed);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        public DescribeAvailabilityOptionsRequest build() {
            return new DescribeAvailabilityOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAvailabilityOptionsRequest> {
        public Builder domainName(String var1);

        public Builder deployed(Boolean var1);
    }
}

