/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.core.async.AsyncRequestProvider;
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainAsyncClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.DefaultCloudSearchDomainAsyncClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface CloudSearchDomainAsyncClient
extends SdkAutoCloseable {
    public static CloudSearchDomainAsyncClient create() {
        return (CloudSearchDomainAsyncClient)CloudSearchDomainAsyncClient.builder().build();
    }

    public static CloudSearchDomainAsyncClientBuilder builder() {
        return new DefaultCloudSearchDomainAsyncClientBuilder();
    }

    default public CompletableFuture<SearchResponse> search(SearchRequest searchRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SuggestResponse> suggest(SuggestRequest suggestRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, AsyncRequestProvider requestProvider) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UploadDocumentsResponse> uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, Path path) {
        return this.uploadDocuments(uploadDocumentsRequest, AsyncRequestProvider.fromFile((Path)path));
    }
}

