/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.DateOptions;

public class DateOptionsUnmarshaller
implements Unmarshaller<DateOptions, StaxUnmarshallerContext> {
    private static final DateOptionsUnmarshaller INSTANCE = new DateOptionsUnmarshaller();

    public DateOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DateOptions.Builder dateOptions = DateOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    dateOptions.defaultValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceField", targetDepth)) {
                    dateOptions.sourceField(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FacetEnabled", targetDepth)) {
                    dateOptions.facetEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchEnabled", targetDepth)) {
                    dateOptions.searchEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReturnEnabled", targetDepth)) {
                    dateOptions.returnEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SortEnabled", targetDepth)) continue;
                dateOptions.sortEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DateOptions)dateOptions.build();
    }

    public static DateOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

