/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudsearch.model.Expression;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefineExpressionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DefineExpressionRequest> {
    private final String domainName;
    private final Expression expression;

    private DefineExpressionRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.expression = builder.expression;
    }

    public String domainName() {
        return this.domainName;
    }

    public Expression expression() {
        return this.expression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.expression() == null ? 0 : this.expression().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineExpressionRequest)) {
            return false;
        }
        DefineExpressionRequest other = (DefineExpressionRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.expression() == null ^ this.expression() == null) {
            return false;
        }
        return other.expression() == null || other.expression().equals(this.expression());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.expression() != null) {
            sb.append("Expression: ").append(this.expression()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Expression": {
                return Optional.of(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Expression expression;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineExpressionRequest model) {
            this.domainName(model.domainName);
            this.expression(model.expression);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Expression.Builder getExpression() {
            return this.expression != null ? this.expression.toBuilder() : null;
        }

        @Override
        public final Builder expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(Expression.BuilderImpl expression) {
            this.expression = expression != null ? expression.build() : null;
        }

        public DefineExpressionRequest build() {
            return new DefineExpressionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefineExpressionRequest> {
        public Builder domainName(String var1);

        public Builder expression(Expression var1);
    }
}

