/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestModel;

@SdkInternalApi
public class SuggestModelMarshaller {
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("query").build();
    private static final MarshallingInfo<Long> FOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("found").build();
    private static final MarshallingInfo<List> SUGGESTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suggestions").build();
    private static final SuggestModelMarshaller INSTANCE = new SuggestModelMarshaller();

    public static SuggestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SuggestModel suggestModel, ProtocolMarshaller protocolMarshaller) {
        if (suggestModel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)suggestModel.query(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)suggestModel.found(), FOUND_BINDING);
            protocolMarshaller.marshall(suggestModel.suggestions(), SUGGESTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

