/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.model.Hit;
import software.amazon.awssdk.services.cloudsearchdomain.model.HitListCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.HitsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Hits
implements StructuredPojo,
ToCopyableBuilder<Builder, Hits> {
    private final Long found;
    private final Long start;
    private final String cursor;
    private final List<Hit> hit;

    private Hits(BuilderImpl builder) {
        this.found = builder.found;
        this.start = builder.start;
        this.cursor = builder.cursor;
        this.hit = builder.hit;
    }

    public Long found() {
        return this.found;
    }

    public Long start() {
        return this.start;
    }

    public String cursor() {
        return this.cursor;
    }

    public List<Hit> hit() {
        return this.hit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.found() == null ? 0 : this.found().hashCode());
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.cursor() == null ? 0 : this.cursor().hashCode());
        hashCode = 31 * hashCode + (this.hit() == null ? 0 : this.hit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hits)) {
            return false;
        }
        Hits other = (Hits)obj;
        if (other.found() == null ^ this.found() == null) {
            return false;
        }
        if (other.found() != null && !other.found().equals(this.found())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.cursor() == null ^ this.cursor() == null) {
            return false;
        }
        if (other.cursor() != null && !other.cursor().equals(this.cursor())) {
            return false;
        }
        if (other.hit() == null ^ this.hit() == null) {
            return false;
        }
        return other.hit() == null || other.hit().equals(this.hit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.found() != null) {
            sb.append("Found: ").append(this.found()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.cursor() != null) {
            sb.append("Cursor: ").append(this.cursor()).append(",");
        }
        if (this.hit() != null) {
            sb.append("Hit: ").append(this.hit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long found;
        private Long start;
        private String cursor;
        private List<Hit> hit;

        private BuilderImpl() {
        }

        private BuilderImpl(Hits model) {
            this.setFound(model.found);
            this.setStart(model.start);
            this.setCursor(model.cursor);
            this.setHit(model.hit);
        }

        public final Long getFound() {
            return this.found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final Long getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final String getCursor() {
            return this.cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public final Collection<Hit> getHit() {
            return this.hit;
        }

        @Override
        public final Builder hit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Hit ... hit) {
            this.hit(Arrays.asList(hit));
            return this;
        }

        public final void setHit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
        }

        public Hits build() {
            return new Hits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Hits> {
        public Builder found(Long var1);

        public Builder start(Long var1);

        public Builder cursor(String var1);

        public Builder hit(Collection<Hit> var1);

        public Builder hit(Hit ... var1);
    }
}

