/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.services.cloudsearch.model.PartitionInstanceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingParameters
implements ToCopyableBuilder<Builder, ScalingParameters> {
    private final String desiredInstanceType;
    private final Integer desiredReplicationCount;
    private final Integer desiredPartitionCount;

    private ScalingParameters(BuilderImpl builder) {
        this.desiredInstanceType = builder.desiredInstanceType;
        this.desiredReplicationCount = builder.desiredReplicationCount;
        this.desiredPartitionCount = builder.desiredPartitionCount;
    }

    public String desiredInstanceType() {
        return this.desiredInstanceType;
    }

    public Integer desiredReplicationCount() {
        return this.desiredReplicationCount;
    }

    public Integer desiredPartitionCount() {
        return this.desiredPartitionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.desiredInstanceType() == null ? 0 : this.desiredInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.desiredReplicationCount() == null ? 0 : this.desiredReplicationCount().hashCode());
        hashCode = 31 * hashCode + (this.desiredPartitionCount() == null ? 0 : this.desiredPartitionCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingParameters)) {
            return false;
        }
        ScalingParameters other = (ScalingParameters)obj;
        if (other.desiredInstanceType() == null ^ this.desiredInstanceType() == null) {
            return false;
        }
        if (other.desiredInstanceType() != null && !other.desiredInstanceType().equals(this.desiredInstanceType())) {
            return false;
        }
        if (other.desiredReplicationCount() == null ^ this.desiredReplicationCount() == null) {
            return false;
        }
        if (other.desiredReplicationCount() != null && !other.desiredReplicationCount().equals(this.desiredReplicationCount())) {
            return false;
        }
        if (other.desiredPartitionCount() == null ^ this.desiredPartitionCount() == null) {
            return false;
        }
        return other.desiredPartitionCount() == null || other.desiredPartitionCount().equals(this.desiredPartitionCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.desiredInstanceType() != null) {
            sb.append("DesiredInstanceType: ").append(this.desiredInstanceType()).append(",");
        }
        if (this.desiredReplicationCount() != null) {
            sb.append("DesiredReplicationCount: ").append(this.desiredReplicationCount()).append(",");
        }
        if (this.desiredPartitionCount() != null) {
            sb.append("DesiredPartitionCount: ").append(this.desiredPartitionCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String desiredInstanceType;
        private Integer desiredReplicationCount;
        private Integer desiredPartitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingParameters model) {
            this.setDesiredInstanceType(model.desiredInstanceType);
            this.setDesiredReplicationCount(model.desiredReplicationCount);
            this.setDesiredPartitionCount(model.desiredPartitionCount);
        }

        public final String getDesiredInstanceType() {
            return this.desiredInstanceType;
        }

        @Override
        public final Builder desiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
            return this;
        }

        @Override
        public final Builder desiredInstanceType(PartitionInstanceType desiredInstanceType) {
            this.desiredInstanceType(desiredInstanceType.toString());
            return this;
        }

        public final void setDesiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
        }

        public final Integer getDesiredReplicationCount() {
            return this.desiredReplicationCount;
        }

        @Override
        public final Builder desiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
            return this;
        }

        public final void setDesiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
        }

        public final Integer getDesiredPartitionCount() {
            return this.desiredPartitionCount;
        }

        @Override
        public final Builder desiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
            return this;
        }

        public final void setDesiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
        }

        public ScalingParameters build() {
            return new ScalingParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingParameters> {
        public Builder desiredInstanceType(String var1);

        public Builder desiredInstanceType(PartitionInstanceType var1);

        public Builder desiredReplicationCount(Integer var1);

        public Builder desiredPartitionCount(Integer var1);
    }
}

