/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestionMatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuggestionMatch
implements StructuredPojo,
ToCopyableBuilder<Builder, SuggestionMatch> {
    private final String suggestion;
    private final Long score;
    private final String id;

    private SuggestionMatch(BuilderImpl builder) {
        this.suggestion = builder.suggestion;
        this.score = builder.score;
        this.id = builder.id;
    }

    public String suggestion() {
        return this.suggestion;
    }

    public Long score() {
        return this.score;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.suggestion() == null ? 0 : this.suggestion().hashCode());
        hashCode = 31 * hashCode + (this.score() == null ? 0 : this.score().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestionMatch)) {
            return false;
        }
        SuggestionMatch other = (SuggestionMatch)obj;
        if (other.suggestion() == null ^ this.suggestion() == null) {
            return false;
        }
        if (other.suggestion() != null && !other.suggestion().equals(this.suggestion())) {
            return false;
        }
        if (other.score() == null ^ this.score() == null) {
            return false;
        }
        if (other.score() != null && !other.score().equals(this.score())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        return other.id() == null || other.id().equals(this.id());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.suggestion() != null) {
            sb.append("Suggestion: ").append(this.suggestion()).append(",");
        }
        if (this.score() != null) {
            sb.append("Score: ").append(this.score()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuggestionMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String suggestion;
        private Long score;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestionMatch model) {
            this.setSuggestion(model.suggestion);
            this.setScore(model.score);
            this.setId(model.id);
        }

        public final String getSuggestion() {
            return this.suggestion;
        }

        @Override
        public final Builder suggestion(String suggestion) {
            this.suggestion = suggestion;
            return this;
        }

        public final void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }

        public final Long getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Long score) {
            this.score = score;
            return this;
        }

        public final void setScore(Long score) {
            this.score = score;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public SuggestionMatch build() {
            return new SuggestionMatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuggestionMatch> {
        public Builder suggestion(String var1);

        public Builder score(Long var1);

        public Builder id(String var1);
    }
}

