/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateScalingParametersRequestMarshaller
implements Marshaller<Request<UpdateScalingParametersRequest>, UpdateScalingParametersRequest> {
    public Request<UpdateScalingParametersRequest> marshall(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ScalingParameters scalingParameters;
        if (updateScalingParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateScalingParametersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateScalingParameters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateScalingParametersRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)updateScalingParametersRequest.domainName()));
        }
        if ((scalingParameters = updateScalingParametersRequest.scalingParameters()) != null) {
            if (scalingParameters.desiredInstanceType() != null) {
                request.addParameter("ScalingParameters.DesiredInstanceType", StringUtils.fromString((String)scalingParameters.desiredInstanceType()));
            }
            if (scalingParameters.desiredReplicationCount() != null) {
                request.addParameter("ScalingParameters.DesiredReplicationCount", StringUtils.fromInteger((Integer)scalingParameters.desiredReplicationCount()));
            }
            if (scalingParameters.desiredPartitionCount() != null) {
                request.addParameter("ScalingParameters.DesiredPartitionCount", StringUtils.fromInteger((Integer)scalingParameters.desiredPartitionCount()));
            }
        }
        return request;
    }
}

