/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;

public class ListDomainNamesResponseUnmarshaller
implements Unmarshaller<ListDomainNamesResponse, StaxUnmarshallerContext> {
    private static ListDomainNamesResponseUnmarshaller INSTANCE;

    public ListDomainNamesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListDomainNamesResponse.Builder listDomainNamesResponse;
        block5: {
            listDomainNamesResponse = ListDomainNamesResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 2;
            }
            HashMap<String, String> domainNames = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listDomainNamesResponse.domainNames(domainNames);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("DomainNames/entry", targetDepth)) continue;
                    if (domainNames == null) {
                        domainNames = new HashMap<String, String>();
                    }
                    Map.Entry<String, String> entry = DomainNamesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    domainNames.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listDomainNamesResponse.domainNames(domainNames);
        }
        return (ListDomainNamesResponse)((Object)listDomainNamesResponse.build());
    }

    public static ListDomainNamesResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListDomainNamesResponseUnmarshaller();
        }
        return INSTANCE;
    }

    private static class DomainNamesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static DomainNamesMapEntryUnmarshaller INSTANCE;

        private DomainNamesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static DomainNamesMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new DomainNamesMapEntryUnmarshaller();
            }
            return INSTANCE;
        }
    }
}

