/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus;
import software.amazon.awssdk.services.cloudsearch.transform.ExpressionUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.OptionStatusUnmarshaller;

public class ExpressionStatusUnmarshaller
implements Unmarshaller<ExpressionStatus, StaxUnmarshallerContext> {
    private static ExpressionStatusUnmarshaller INSTANCE;

    public ExpressionStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ExpressionStatus.Builder expressionStatus = ExpressionStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Options", targetDepth)) {
                    expressionStatus.options(ExpressionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                expressionStatus.status(OptionStatusUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ExpressionStatus)expressionStatus.build();
    }

    public static ExpressionStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExpressionStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

