/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudsearch.transform.LimitsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ServiceEndpointUnmarshaller;

public class DomainStatusUnmarshaller
implements Unmarshaller<DomainStatus, StaxUnmarshallerContext> {
    private static DomainStatusUnmarshaller INSTANCE;

    public DomainStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DomainStatus.Builder domainStatus = DomainStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DomainId", targetDepth)) {
                    domainStatus.domainId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    domainStatus.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ARN", targetDepth)) {
                    domainStatus.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Created", targetDepth)) {
                    domainStatus.created(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Deleted", targetDepth)) {
                    domainStatus.deleted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DocService", targetDepth)) {
                    domainStatus.docService(ServiceEndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchService", targetDepth)) {
                    domainStatus.searchService(ServiceEndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequiresIndexDocuments", targetDepth)) {
                    domainStatus.requiresIndexDocuments(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Processing", targetDepth)) {
                    domainStatus.processing(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchInstanceType", targetDepth)) {
                    domainStatus.searchInstanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchPartitionCount", targetDepth)) {
                    domainStatus.searchPartitionCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchInstanceCount", targetDepth)) {
                    domainStatus.searchInstanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Limits", targetDepth)) continue;
                domainStatus.limits(LimitsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DomainStatus)domainStatus.build();
    }

    public static DomainStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DomainStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

