/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisScheme;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DefineAnalysisSchemeRequestMarshaller
implements Marshaller<Request<DefineAnalysisSchemeRequest>, DefineAnalysisSchemeRequest> {
    public Request<DefineAnalysisSchemeRequest> marshall(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        AnalysisScheme analysisScheme;
        if (defineAnalysisSchemeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineAnalysisSchemeRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineAnalysisScheme");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineAnalysisSchemeRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineAnalysisSchemeRequest.domainName()));
        }
        if ((analysisScheme = defineAnalysisSchemeRequest.analysisScheme()) != null) {
            AnalysisOptions analysisOptions;
            if (analysisScheme.analysisSchemeName() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeName", StringUtils.fromString((String)analysisScheme.analysisSchemeName()));
            }
            if (analysisScheme.analysisSchemeLanguage() != null) {
                request.addParameter("AnalysisScheme.AnalysisSchemeLanguage", StringUtils.fromString((String)analysisScheme.analysisSchemeLanguage()));
            }
            if ((analysisOptions = analysisScheme.analysisOptions()) != null) {
                if (analysisOptions.synonyms() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Synonyms", StringUtils.fromString((String)analysisOptions.synonyms()));
                }
                if (analysisOptions.stopwords() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.Stopwords", StringUtils.fromString((String)analysisOptions.stopwords()));
                }
                if (analysisOptions.stemmingDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.StemmingDictionary", StringUtils.fromString((String)analysisOptions.stemmingDictionary()));
                }
                if (analysisOptions.japaneseTokenizationDictionary() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.JapaneseTokenizationDictionary", StringUtils.fromString((String)analysisOptions.japaneseTokenizationDictionary()));
                }
                if (analysisOptions.algorithmicStemming() != null) {
                    request.addParameter("AnalysisScheme.AnalysisOptions.AlgorithmicStemming", StringUtils.fromString((String)analysisOptions.algorithmicStemming()));
                }
            }
        }
        return request;
    }
}

