/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.services.cloudsearch.model.AlgorithmicStemming;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalysisOptions
implements ToCopyableBuilder<Builder, AnalysisOptions> {
    private final String synonyms;
    private final String stopwords;
    private final String stemmingDictionary;
    private final String japaneseTokenizationDictionary;
    private final String algorithmicStemming;

    private AnalysisOptions(BuilderImpl builder) {
        this.synonyms = builder.synonyms;
        this.stopwords = builder.stopwords;
        this.stemmingDictionary = builder.stemmingDictionary;
        this.japaneseTokenizationDictionary = builder.japaneseTokenizationDictionary;
        this.algorithmicStemming = builder.algorithmicStemming;
    }

    public String synonyms() {
        return this.synonyms;
    }

    public String stopwords() {
        return this.stopwords;
    }

    public String stemmingDictionary() {
        return this.stemmingDictionary;
    }

    public String japaneseTokenizationDictionary() {
        return this.japaneseTokenizationDictionary;
    }

    public String algorithmicStemming() {
        return this.algorithmicStemming;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.synonyms() == null ? 0 : this.synonyms().hashCode());
        hashCode = 31 * hashCode + (this.stopwords() == null ? 0 : this.stopwords().hashCode());
        hashCode = 31 * hashCode + (this.stemmingDictionary() == null ? 0 : this.stemmingDictionary().hashCode());
        hashCode = 31 * hashCode + (this.japaneseTokenizationDictionary() == null ? 0 : this.japaneseTokenizationDictionary().hashCode());
        hashCode = 31 * hashCode + (this.algorithmicStemming() == null ? 0 : this.algorithmicStemming().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisOptions)) {
            return false;
        }
        AnalysisOptions other = (AnalysisOptions)obj;
        if (other.synonyms() == null ^ this.synonyms() == null) {
            return false;
        }
        if (other.synonyms() != null && !other.synonyms().equals(this.synonyms())) {
            return false;
        }
        if (other.stopwords() == null ^ this.stopwords() == null) {
            return false;
        }
        if (other.stopwords() != null && !other.stopwords().equals(this.stopwords())) {
            return false;
        }
        if (other.stemmingDictionary() == null ^ this.stemmingDictionary() == null) {
            return false;
        }
        if (other.stemmingDictionary() != null && !other.stemmingDictionary().equals(this.stemmingDictionary())) {
            return false;
        }
        if (other.japaneseTokenizationDictionary() == null ^ this.japaneseTokenizationDictionary() == null) {
            return false;
        }
        if (other.japaneseTokenizationDictionary() != null && !other.japaneseTokenizationDictionary().equals(this.japaneseTokenizationDictionary())) {
            return false;
        }
        if (other.algorithmicStemming() == null ^ this.algorithmicStemming() == null) {
            return false;
        }
        return other.algorithmicStemming() == null || other.algorithmicStemming().equals(this.algorithmicStemming());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.synonyms() != null) {
            sb.append("Synonyms: ").append(this.synonyms()).append(",");
        }
        if (this.stopwords() != null) {
            sb.append("Stopwords: ").append(this.stopwords()).append(",");
        }
        if (this.stemmingDictionary() != null) {
            sb.append("StemmingDictionary: ").append(this.stemmingDictionary()).append(",");
        }
        if (this.japaneseTokenizationDictionary() != null) {
            sb.append("JapaneseTokenizationDictionary: ").append(this.japaneseTokenizationDictionary()).append(",");
        }
        if (this.algorithmicStemming() != null) {
            sb.append("AlgorithmicStemming: ").append(this.algorithmicStemming()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String synonyms;
        private String stopwords;
        private String stemmingDictionary;
        private String japaneseTokenizationDictionary;
        private String algorithmicStemming;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisOptions model) {
            this.setSynonyms(model.synonyms);
            this.setStopwords(model.stopwords);
            this.setStemmingDictionary(model.stemmingDictionary);
            this.setJapaneseTokenizationDictionary(model.japaneseTokenizationDictionary);
            this.setAlgorithmicStemming(model.algorithmicStemming);
        }

        public final String getSynonyms() {
            return this.synonyms;
        }

        @Override
        public final Builder synonyms(String synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public final void setSynonyms(String synonyms) {
            this.synonyms = synonyms;
        }

        public final String getStopwords() {
            return this.stopwords;
        }

        @Override
        public final Builder stopwords(String stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public final void setStopwords(String stopwords) {
            this.stopwords = stopwords;
        }

        public final String getStemmingDictionary() {
            return this.stemmingDictionary;
        }

        @Override
        public final Builder stemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
            return this;
        }

        public final void setStemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
        }

        public final String getJapaneseTokenizationDictionary() {
            return this.japaneseTokenizationDictionary;
        }

        @Override
        public final Builder japaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
            return this;
        }

        public final void setJapaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
        }

        public final String getAlgorithmicStemming() {
            return this.algorithmicStemming;
        }

        @Override
        public final Builder algorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
            return this;
        }

        @Override
        public final Builder algorithmicStemming(AlgorithmicStemming algorithmicStemming) {
            this.algorithmicStemming(algorithmicStemming.toString());
            return this;
        }

        public final void setAlgorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
        }

        public final void setAlgorithmicStemming(AlgorithmicStemming algorithmicStemming) {
            this.algorithmicStemming(algorithmicStemming.toString());
        }

        public AnalysisOptions build() {
            return new AnalysisOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalysisOptions> {
        public Builder synonyms(String var1);

        public Builder stopwords(String var1);

        public Builder stemmingDictionary(String var1);

        public Builder japaneseTokenizationDictionary(String var1);

        public Builder algorithmicStemming(String var1);

        public Builder algorithmicStemming(AlgorithmicStemming var1);
    }
}

