/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;

public class DescribeSuggestersRequestMarshaller
implements Marshaller<Request<DescribeSuggestersRequest>, DescribeSuggestersRequest> {
    public Request<DescribeSuggestersRequest> marshall(DescribeSuggestersRequest describeSuggestersRequest) {
        if (describeSuggestersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeSuggestersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeSuggesters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSuggestersRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)describeSuggestersRequest.domainName()));
        }
        if (describeSuggestersRequest.suggesterNames().isEmpty() && !(describeSuggestersRequest.suggesterNames() instanceof SdkAutoConstructList)) {
            request.addParameter("SuggesterNames", "");
        } else if (!describeSuggestersRequest.suggesterNames().isEmpty() && !(describeSuggestersRequest.suggesterNames() instanceof SdkAutoConstructList)) {
            List<String> suggesterNamesList = describeSuggestersRequest.suggesterNames();
            int suggesterNamesListIndex = 1;
            for (String suggesterNamesListValue : suggesterNamesList) {
                if (suggesterNamesListValue != null) {
                    request.addParameter("SuggesterNames.member." + suggesterNamesListIndex, StringConversion.fromString((String)suggesterNamesListValue));
                }
                ++suggesterNamesListIndex;
            }
        }
        if (describeSuggestersRequest.deployed() != null) {
            request.addParameter("Deployed", StringConversion.fromBoolean((Boolean)describeSuggestersRequest.deployed()));
        }
        return request;
    }
}

