/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;

public class DescribeIndexFieldsRequestMarshaller
implements Marshaller<Request<DescribeIndexFieldsRequest>, DescribeIndexFieldsRequest> {
    public Request<DescribeIndexFieldsRequest> marshall(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        if (describeIndexFieldsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeIndexFieldsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeIndexFields");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeIndexFieldsRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)describeIndexFieldsRequest.domainName()));
        }
        if (describeIndexFieldsRequest.fieldNames().isEmpty() && !(describeIndexFieldsRequest.fieldNames() instanceof SdkAutoConstructList)) {
            request.addParameter("FieldNames", "");
        } else if (!describeIndexFieldsRequest.fieldNames().isEmpty() && !(describeIndexFieldsRequest.fieldNames() instanceof SdkAutoConstructList)) {
            List<String> fieldNamesList = describeIndexFieldsRequest.fieldNames();
            int fieldNamesListIndex = 1;
            for (String fieldNamesListValue : fieldNamesList) {
                if (fieldNamesListValue != null) {
                    request.addParameter("FieldNames.member." + fieldNamesListIndex, StringConversion.fromString((String)fieldNamesListValue));
                }
                ++fieldNamesListIndex;
            }
        }
        if (describeIndexFieldsRequest.deployed() != null) {
            request.addParameter("Deployed", StringConversion.fromBoolean((Boolean)describeIndexFieldsRequest.deployed()));
        }
        return request;
    }
}

