/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;

public class DeleteIndexFieldRequestMarshaller
implements Marshaller<Request<DeleteIndexFieldRequest>, DeleteIndexFieldRequest> {
    public Request<DeleteIndexFieldRequest> marshall(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        if (deleteIndexFieldRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteIndexFieldRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DeleteIndexField");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIndexFieldRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)deleteIndexFieldRequest.domainName()));
        }
        if (deleteIndexFieldRequest.indexFieldName() != null) {
            request.addParameter("IndexFieldName", StringConversion.fromString((String)deleteIndexFieldRequest.indexFieldName()));
        }
        return request;
    }
}

