/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudsearch.model.DateArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DateOptions;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DoubleArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DoubleOptions;
import software.amazon.awssdk.services.cloudsearch.model.IndexField;
import software.amazon.awssdk.services.cloudsearch.model.IntArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.IntOptions;
import software.amazon.awssdk.services.cloudsearch.model.LatLonOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextOptions;

public class DefineIndexFieldRequestMarshaller
implements Marshaller<Request<DefineIndexFieldRequest>, DefineIndexFieldRequest> {
    public Request<DefineIndexFieldRequest> marshall(DefineIndexFieldRequest defineIndexFieldRequest) {
        IndexField indexField;
        if (defineIndexFieldRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)defineIndexFieldRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineIndexField");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineIndexFieldRequest.domainName() != null) {
            request.addParameter("DomainName", StringConversion.fromString((String)defineIndexFieldRequest.domainName()));
        }
        if ((indexField = defineIndexFieldRequest.indexField()) != null) {
            DateArrayOptions dateArrayOptions;
            TextArrayOptions textArrayOptions;
            LiteralArrayOptions literalArrayOptions;
            DoubleArrayOptions doubleArrayOptions;
            IntArrayOptions intArrayOptions;
            LatLonOptions latLonOptions;
            DateOptions dateOptions;
            TextOptions textOptions;
            LiteralOptions literalOptions;
            DoubleOptions doubleOptions;
            IntOptions intOptions;
            if (indexField.indexFieldName() != null) {
                request.addParameter("IndexField.IndexFieldName", StringConversion.fromString((String)indexField.indexFieldName()));
            }
            if (indexField.indexFieldTypeAsString() != null) {
                request.addParameter("IndexField.IndexFieldType", StringConversion.fromString((String)indexField.indexFieldTypeAsString()));
            }
            if ((intOptions = indexField.intOptions()) != null) {
                if (intOptions.defaultValue() != null) {
                    request.addParameter("IndexField.IntOptions.DefaultValue", StringConversion.fromLong((Long)intOptions.defaultValue()));
                }
                if (intOptions.sourceField() != null) {
                    request.addParameter("IndexField.IntOptions.SourceField", StringConversion.fromString((String)intOptions.sourceField()));
                }
                if (intOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)intOptions.facetEnabled()));
                }
                if (intOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)intOptions.searchEnabled()));
                }
                if (intOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)intOptions.returnEnabled()));
                }
                if (intOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SortEnabled", StringConversion.fromBoolean((Boolean)intOptions.sortEnabled()));
                }
            }
            if ((doubleOptions = indexField.doubleOptions()) != null) {
                if (doubleOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DoubleOptions.DefaultValue", StringConversion.fromDouble((Double)doubleOptions.defaultValue()));
                }
                if (doubleOptions.sourceField() != null) {
                    request.addParameter("IndexField.DoubleOptions.SourceField", StringConversion.fromString((String)doubleOptions.sourceField()));
                }
                if (doubleOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)doubleOptions.facetEnabled()));
                }
                if (doubleOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)doubleOptions.searchEnabled()));
                }
                if (doubleOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)doubleOptions.returnEnabled()));
                }
                if (doubleOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SortEnabled", StringConversion.fromBoolean((Boolean)doubleOptions.sortEnabled()));
                }
            }
            if ((literalOptions = indexField.literalOptions()) != null) {
                if (literalOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LiteralOptions.DefaultValue", StringConversion.fromString((String)literalOptions.defaultValue()));
                }
                if (literalOptions.sourceField() != null) {
                    request.addParameter("IndexField.LiteralOptions.SourceField", StringConversion.fromString((String)literalOptions.sourceField()));
                }
                if (literalOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)literalOptions.facetEnabled()));
                }
                if (literalOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)literalOptions.searchEnabled()));
                }
                if (literalOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)literalOptions.returnEnabled()));
                }
                if (literalOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SortEnabled", StringConversion.fromBoolean((Boolean)literalOptions.sortEnabled()));
                }
            }
            if ((textOptions = indexField.textOptions()) != null) {
                if (textOptions.defaultValue() != null) {
                    request.addParameter("IndexField.TextOptions.DefaultValue", StringConversion.fromString((String)textOptions.defaultValue()));
                }
                if (textOptions.sourceField() != null) {
                    request.addParameter("IndexField.TextOptions.SourceField", StringConversion.fromString((String)textOptions.sourceField()));
                }
                if (textOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)textOptions.returnEnabled()));
                }
                if (textOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.SortEnabled", StringConversion.fromBoolean((Boolean)textOptions.sortEnabled()));
                }
                if (textOptions.highlightEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.HighlightEnabled", StringConversion.fromBoolean((Boolean)textOptions.highlightEnabled()));
                }
                if (textOptions.analysisScheme() != null) {
                    request.addParameter("IndexField.TextOptions.AnalysisScheme", StringConversion.fromString((String)textOptions.analysisScheme()));
                }
            }
            if ((dateOptions = indexField.dateOptions()) != null) {
                if (dateOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DateOptions.DefaultValue", StringConversion.fromString((String)dateOptions.defaultValue()));
                }
                if (dateOptions.sourceField() != null) {
                    request.addParameter("IndexField.DateOptions.SourceField", StringConversion.fromString((String)dateOptions.sourceField()));
                }
                if (dateOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)dateOptions.facetEnabled()));
                }
                if (dateOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)dateOptions.searchEnabled()));
                }
                if (dateOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)dateOptions.returnEnabled()));
                }
                if (dateOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SortEnabled", StringConversion.fromBoolean((Boolean)dateOptions.sortEnabled()));
                }
            }
            if ((latLonOptions = indexField.latLonOptions()) != null) {
                if (latLonOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LatLonOptions.DefaultValue", StringConversion.fromString((String)latLonOptions.defaultValue()));
                }
                if (latLonOptions.sourceField() != null) {
                    request.addParameter("IndexField.LatLonOptions.SourceField", StringConversion.fromString((String)latLonOptions.sourceField()));
                }
                if (latLonOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)latLonOptions.facetEnabled()));
                }
                if (latLonOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)latLonOptions.searchEnabled()));
                }
                if (latLonOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)latLonOptions.returnEnabled()));
                }
                if (latLonOptions.sortEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SortEnabled", StringConversion.fromBoolean((Boolean)latLonOptions.sortEnabled()));
                }
            }
            if ((intArrayOptions = indexField.intArrayOptions()) != null) {
                if (intArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.IntArrayOptions.DefaultValue", StringConversion.fromLong((Long)intArrayOptions.defaultValue()));
                }
                if (intArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SourceFields", StringConversion.fromString((String)intArrayOptions.sourceFields()));
                }
                if (intArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)intArrayOptions.facetEnabled()));
                }
                if (intArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)intArrayOptions.searchEnabled()));
                }
                if (intArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)intArrayOptions.returnEnabled()));
                }
            }
            if ((doubleArrayOptions = indexField.doubleArrayOptions()) != null) {
                if (doubleArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.DefaultValue", StringConversion.fromDouble((Double)doubleArrayOptions.defaultValue()));
                }
                if (doubleArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SourceFields", StringConversion.fromString((String)doubleArrayOptions.sourceFields()));
                }
                if (doubleArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)doubleArrayOptions.facetEnabled()));
                }
                if (doubleArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)doubleArrayOptions.searchEnabled()));
                }
                if (doubleArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)doubleArrayOptions.returnEnabled()));
                }
            }
            if ((literalArrayOptions = indexField.literalArrayOptions()) != null) {
                if (literalArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.DefaultValue", StringConversion.fromString((String)literalArrayOptions.defaultValue()));
                }
                if (literalArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SourceFields", StringConversion.fromString((String)literalArrayOptions.sourceFields()));
                }
                if (literalArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)literalArrayOptions.facetEnabled()));
                }
                if (literalArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)literalArrayOptions.searchEnabled()));
                }
                if (literalArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)literalArrayOptions.returnEnabled()));
                }
            }
            if ((textArrayOptions = indexField.textArrayOptions()) != null) {
                if (textArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.TextArrayOptions.DefaultValue", StringConversion.fromString((String)textArrayOptions.defaultValue()));
                }
                if (textArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.TextArrayOptions.SourceFields", StringConversion.fromString((String)textArrayOptions.sourceFields()));
                }
                if (textArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)textArrayOptions.returnEnabled()));
                }
                if (textArrayOptions.highlightEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.HighlightEnabled", StringConversion.fromBoolean((Boolean)textArrayOptions.highlightEnabled()));
                }
                if (textArrayOptions.analysisScheme() != null) {
                    request.addParameter("IndexField.TextArrayOptions.AnalysisScheme", StringConversion.fromString((String)textArrayOptions.analysisScheme()));
                }
            }
            if ((dateArrayOptions = indexField.dateArrayOptions()) != null) {
                if (dateArrayOptions.defaultValue() != null) {
                    request.addParameter("IndexField.DateArrayOptions.DefaultValue", StringConversion.fromString((String)dateArrayOptions.defaultValue()));
                }
                if (dateArrayOptions.sourceFields() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SourceFields", StringConversion.fromString((String)dateArrayOptions.sourceFields()));
                }
                if (dateArrayOptions.facetEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.FacetEnabled", StringConversion.fromBoolean((Boolean)dateArrayOptions.facetEnabled()));
                }
                if (dateArrayOptions.searchEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SearchEnabled", StringConversion.fromBoolean((Boolean)dateArrayOptions.searchEnabled()));
                }
                if (dateArrayOptions.returnEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.ReturnEnabled", StringConversion.fromBoolean((Boolean)dateArrayOptions.returnEnabled()));
                }
            }
        }
        return request;
    }
}

