/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearch.model.IndexField;
import software.amazon.awssdk.services.cloudsearch.model.OptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexFieldStatus
implements ToCopyableBuilder<Builder, IndexFieldStatus> {
    private final IndexField options;
    private final OptionStatus status;

    private IndexFieldStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public IndexField options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFieldStatus)) {
            return false;
        }
        IndexFieldStatus other = (IndexFieldStatus)obj;
        return Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"IndexFieldStatus").add("Options", (Object)this.options()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private IndexField options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFieldStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final IndexField.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(IndexField options) {
            this.options = options;
            return this;
        }

        public final void setOptions(IndexField.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public IndexFieldStatus build() {
            return new IndexFieldStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexFieldStatus> {
        public Builder options(IndexField var1);

        default public Builder options(Consumer<IndexField.Builder> options) {
            return this.options((IndexField)((IndexField.Builder)IndexField.builder().applyMutation(options)).build());
        }

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().applyMutation(status)).build());
        }
    }
}

