/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearch.model.DateArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DateOptions;
import software.amazon.awssdk.services.cloudsearch.model.DoubleArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.DoubleOptions;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldType;
import software.amazon.awssdk.services.cloudsearch.model.IntArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.IntOptions;
import software.amazon.awssdk.services.cloudsearch.model.LatLonOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.LiteralOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextArrayOptions;
import software.amazon.awssdk.services.cloudsearch.model.TextOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexField
implements ToCopyableBuilder<Builder, IndexField> {
    private final String indexFieldName;
    private final String indexFieldType;
    private final IntOptions intOptions;
    private final DoubleOptions doubleOptions;
    private final LiteralOptions literalOptions;
    private final TextOptions textOptions;
    private final DateOptions dateOptions;
    private final LatLonOptions latLonOptions;
    private final IntArrayOptions intArrayOptions;
    private final DoubleArrayOptions doubleArrayOptions;
    private final LiteralArrayOptions literalArrayOptions;
    private final TextArrayOptions textArrayOptions;
    private final DateArrayOptions dateArrayOptions;

    private IndexField(BuilderImpl builder) {
        this.indexFieldName = builder.indexFieldName;
        this.indexFieldType = builder.indexFieldType;
        this.intOptions = builder.intOptions;
        this.doubleOptions = builder.doubleOptions;
        this.literalOptions = builder.literalOptions;
        this.textOptions = builder.textOptions;
        this.dateOptions = builder.dateOptions;
        this.latLonOptions = builder.latLonOptions;
        this.intArrayOptions = builder.intArrayOptions;
        this.doubleArrayOptions = builder.doubleArrayOptions;
        this.literalArrayOptions = builder.literalArrayOptions;
        this.textArrayOptions = builder.textArrayOptions;
        this.dateArrayOptions = builder.dateArrayOptions;
    }

    public String indexFieldName() {
        return this.indexFieldName;
    }

    public IndexFieldType indexFieldType() {
        return IndexFieldType.fromValue(this.indexFieldType);
    }

    public String indexFieldTypeAsString() {
        return this.indexFieldType;
    }

    public IntOptions intOptions() {
        return this.intOptions;
    }

    public DoubleOptions doubleOptions() {
        return this.doubleOptions;
    }

    public LiteralOptions literalOptions() {
        return this.literalOptions;
    }

    public TextOptions textOptions() {
        return this.textOptions;
    }

    public DateOptions dateOptions() {
        return this.dateOptions;
    }

    public LatLonOptions latLonOptions() {
        return this.latLonOptions;
    }

    public IntArrayOptions intArrayOptions() {
        return this.intArrayOptions;
    }

    public DoubleArrayOptions doubleArrayOptions() {
        return this.doubleArrayOptions;
    }

    public LiteralArrayOptions literalArrayOptions() {
        return this.literalArrayOptions;
    }

    public TextArrayOptions textArrayOptions() {
        return this.textArrayOptions;
    }

    public DateArrayOptions dateArrayOptions() {
        return this.dateArrayOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexFieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.literalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.textOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.latLonOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.intArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.literalArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.textArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateArrayOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField other = (IndexField)obj;
        return Objects.equals(this.indexFieldName(), other.indexFieldName()) && Objects.equals(this.indexFieldTypeAsString(), other.indexFieldTypeAsString()) && Objects.equals(this.intOptions(), other.intOptions()) && Objects.equals(this.doubleOptions(), other.doubleOptions()) && Objects.equals(this.literalOptions(), other.literalOptions()) && Objects.equals(this.textOptions(), other.textOptions()) && Objects.equals(this.dateOptions(), other.dateOptions()) && Objects.equals(this.latLonOptions(), other.latLonOptions()) && Objects.equals(this.intArrayOptions(), other.intArrayOptions()) && Objects.equals(this.doubleArrayOptions(), other.doubleArrayOptions()) && Objects.equals(this.literalArrayOptions(), other.literalArrayOptions()) && Objects.equals(this.textArrayOptions(), other.textArrayOptions()) && Objects.equals(this.dateArrayOptions(), other.dateArrayOptions());
    }

    public String toString() {
        return ToString.builder((String)"IndexField").add("IndexFieldName", (Object)this.indexFieldName()).add("IndexFieldType", (Object)this.indexFieldTypeAsString()).add("IntOptions", (Object)this.intOptions()).add("DoubleOptions", (Object)this.doubleOptions()).add("LiteralOptions", (Object)this.literalOptions()).add("TextOptions", (Object)this.textOptions()).add("DateOptions", (Object)this.dateOptions()).add("LatLonOptions", (Object)this.latLonOptions()).add("IntArrayOptions", (Object)this.intArrayOptions()).add("DoubleArrayOptions", (Object)this.doubleArrayOptions()).add("LiteralArrayOptions", (Object)this.literalArrayOptions()).add("TextArrayOptions", (Object)this.textArrayOptions()).add("DateArrayOptions", (Object)this.dateArrayOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexFieldName": {
                return Optional.ofNullable(clazz.cast(this.indexFieldName()));
            }
            case "IndexFieldType": {
                return Optional.ofNullable(clazz.cast(this.indexFieldTypeAsString()));
            }
            case "IntOptions": {
                return Optional.ofNullable(clazz.cast(this.intOptions()));
            }
            case "DoubleOptions": {
                return Optional.ofNullable(clazz.cast(this.doubleOptions()));
            }
            case "LiteralOptions": {
                return Optional.ofNullable(clazz.cast(this.literalOptions()));
            }
            case "TextOptions": {
                return Optional.ofNullable(clazz.cast(this.textOptions()));
            }
            case "DateOptions": {
                return Optional.ofNullable(clazz.cast(this.dateOptions()));
            }
            case "LatLonOptions": {
                return Optional.ofNullable(clazz.cast(this.latLonOptions()));
            }
            case "IntArrayOptions": {
                return Optional.ofNullable(clazz.cast(this.intArrayOptions()));
            }
            case "DoubleArrayOptions": {
                return Optional.ofNullable(clazz.cast(this.doubleArrayOptions()));
            }
            case "LiteralArrayOptions": {
                return Optional.ofNullable(clazz.cast(this.literalArrayOptions()));
            }
            case "TextArrayOptions": {
                return Optional.ofNullable(clazz.cast(this.textArrayOptions()));
            }
            case "DateArrayOptions": {
                return Optional.ofNullable(clazz.cast(this.dateArrayOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String indexFieldName;
        private String indexFieldType;
        private IntOptions intOptions;
        private DoubleOptions doubleOptions;
        private LiteralOptions literalOptions;
        private TextOptions textOptions;
        private DateOptions dateOptions;
        private LatLonOptions latLonOptions;
        private IntArrayOptions intArrayOptions;
        private DoubleArrayOptions doubleArrayOptions;
        private LiteralArrayOptions literalArrayOptions;
        private TextArrayOptions textArrayOptions;
        private DateArrayOptions dateArrayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexField model) {
            this.indexFieldName(model.indexFieldName);
            this.indexFieldType(model.indexFieldType);
            this.intOptions(model.intOptions);
            this.doubleOptions(model.doubleOptions);
            this.literalOptions(model.literalOptions);
            this.textOptions(model.textOptions);
            this.dateOptions(model.dateOptions);
            this.latLonOptions(model.latLonOptions);
            this.intArrayOptions(model.intArrayOptions);
            this.doubleArrayOptions(model.doubleArrayOptions);
            this.literalArrayOptions(model.literalArrayOptions);
            this.textArrayOptions(model.textArrayOptions);
            this.dateArrayOptions(model.dateArrayOptions);
        }

        public final String getIndexFieldName() {
            return this.indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        public final String getIndexFieldType() {
            return this.indexFieldType;
        }

        @Override
        public final Builder indexFieldType(String indexFieldType) {
            this.indexFieldType = indexFieldType;
            return this;
        }

        @Override
        public final Builder indexFieldType(IndexFieldType indexFieldType) {
            this.indexFieldType(indexFieldType.toString());
            return this;
        }

        public final void setIndexFieldType(String indexFieldType) {
            this.indexFieldType = indexFieldType;
        }

        public final IntOptions.Builder getIntOptions() {
            return this.intOptions != null ? this.intOptions.toBuilder() : null;
        }

        @Override
        public final Builder intOptions(IntOptions intOptions) {
            this.intOptions = intOptions;
            return this;
        }

        public final void setIntOptions(IntOptions.BuilderImpl intOptions) {
            this.intOptions = intOptions != null ? intOptions.build() : null;
        }

        public final DoubleOptions.Builder getDoubleOptions() {
            return this.doubleOptions != null ? this.doubleOptions.toBuilder() : null;
        }

        @Override
        public final Builder doubleOptions(DoubleOptions doubleOptions) {
            this.doubleOptions = doubleOptions;
            return this;
        }

        public final void setDoubleOptions(DoubleOptions.BuilderImpl doubleOptions) {
            this.doubleOptions = doubleOptions != null ? doubleOptions.build() : null;
        }

        public final LiteralOptions.Builder getLiteralOptions() {
            return this.literalOptions != null ? this.literalOptions.toBuilder() : null;
        }

        @Override
        public final Builder literalOptions(LiteralOptions literalOptions) {
            this.literalOptions = literalOptions;
            return this;
        }

        public final void setLiteralOptions(LiteralOptions.BuilderImpl literalOptions) {
            this.literalOptions = literalOptions != null ? literalOptions.build() : null;
        }

        public final TextOptions.Builder getTextOptions() {
            return this.textOptions != null ? this.textOptions.toBuilder() : null;
        }

        @Override
        public final Builder textOptions(TextOptions textOptions) {
            this.textOptions = textOptions;
            return this;
        }

        public final void setTextOptions(TextOptions.BuilderImpl textOptions) {
            this.textOptions = textOptions != null ? textOptions.build() : null;
        }

        public final DateOptions.Builder getDateOptions() {
            return this.dateOptions != null ? this.dateOptions.toBuilder() : null;
        }

        @Override
        public final Builder dateOptions(DateOptions dateOptions) {
            this.dateOptions = dateOptions;
            return this;
        }

        public final void setDateOptions(DateOptions.BuilderImpl dateOptions) {
            this.dateOptions = dateOptions != null ? dateOptions.build() : null;
        }

        public final LatLonOptions.Builder getLatLonOptions() {
            return this.latLonOptions != null ? this.latLonOptions.toBuilder() : null;
        }

        @Override
        public final Builder latLonOptions(LatLonOptions latLonOptions) {
            this.latLonOptions = latLonOptions;
            return this;
        }

        public final void setLatLonOptions(LatLonOptions.BuilderImpl latLonOptions) {
            this.latLonOptions = latLonOptions != null ? latLonOptions.build() : null;
        }

        public final IntArrayOptions.Builder getIntArrayOptions() {
            return this.intArrayOptions != null ? this.intArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder intArrayOptions(IntArrayOptions intArrayOptions) {
            this.intArrayOptions = intArrayOptions;
            return this;
        }

        public final void setIntArrayOptions(IntArrayOptions.BuilderImpl intArrayOptions) {
            this.intArrayOptions = intArrayOptions != null ? intArrayOptions.build() : null;
        }

        public final DoubleArrayOptions.Builder getDoubleArrayOptions() {
            return this.doubleArrayOptions != null ? this.doubleArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder doubleArrayOptions(DoubleArrayOptions doubleArrayOptions) {
            this.doubleArrayOptions = doubleArrayOptions;
            return this;
        }

        public final void setDoubleArrayOptions(DoubleArrayOptions.BuilderImpl doubleArrayOptions) {
            this.doubleArrayOptions = doubleArrayOptions != null ? doubleArrayOptions.build() : null;
        }

        public final LiteralArrayOptions.Builder getLiteralArrayOptions() {
            return this.literalArrayOptions != null ? this.literalArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder literalArrayOptions(LiteralArrayOptions literalArrayOptions) {
            this.literalArrayOptions = literalArrayOptions;
            return this;
        }

        public final void setLiteralArrayOptions(LiteralArrayOptions.BuilderImpl literalArrayOptions) {
            this.literalArrayOptions = literalArrayOptions != null ? literalArrayOptions.build() : null;
        }

        public final TextArrayOptions.Builder getTextArrayOptions() {
            return this.textArrayOptions != null ? this.textArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder textArrayOptions(TextArrayOptions textArrayOptions) {
            this.textArrayOptions = textArrayOptions;
            return this;
        }

        public final void setTextArrayOptions(TextArrayOptions.BuilderImpl textArrayOptions) {
            this.textArrayOptions = textArrayOptions != null ? textArrayOptions.build() : null;
        }

        public final DateArrayOptions.Builder getDateArrayOptions() {
            return this.dateArrayOptions != null ? this.dateArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder dateArrayOptions(DateArrayOptions dateArrayOptions) {
            this.dateArrayOptions = dateArrayOptions;
            return this;
        }

        public final void setDateArrayOptions(DateArrayOptions.BuilderImpl dateArrayOptions) {
            this.dateArrayOptions = dateArrayOptions != null ? dateArrayOptions.build() : null;
        }

        public IndexField build() {
            return new IndexField(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexField> {
        public Builder indexFieldName(String var1);

        public Builder indexFieldType(String var1);

        public Builder indexFieldType(IndexFieldType var1);

        public Builder intOptions(IntOptions var1);

        default public Builder intOptions(Consumer<IntOptions.Builder> intOptions) {
            return this.intOptions((IntOptions)((IntOptions.Builder)IntOptions.builder().applyMutation(intOptions)).build());
        }

        public Builder doubleOptions(DoubleOptions var1);

        default public Builder doubleOptions(Consumer<DoubleOptions.Builder> doubleOptions) {
            return this.doubleOptions((DoubleOptions)((DoubleOptions.Builder)DoubleOptions.builder().applyMutation(doubleOptions)).build());
        }

        public Builder literalOptions(LiteralOptions var1);

        default public Builder literalOptions(Consumer<LiteralOptions.Builder> literalOptions) {
            return this.literalOptions((LiteralOptions)((LiteralOptions.Builder)LiteralOptions.builder().applyMutation(literalOptions)).build());
        }

        public Builder textOptions(TextOptions var1);

        default public Builder textOptions(Consumer<TextOptions.Builder> textOptions) {
            return this.textOptions((TextOptions)((TextOptions.Builder)TextOptions.builder().applyMutation(textOptions)).build());
        }

        public Builder dateOptions(DateOptions var1);

        default public Builder dateOptions(Consumer<DateOptions.Builder> dateOptions) {
            return this.dateOptions((DateOptions)((DateOptions.Builder)DateOptions.builder().applyMutation(dateOptions)).build());
        }

        public Builder latLonOptions(LatLonOptions var1);

        default public Builder latLonOptions(Consumer<LatLonOptions.Builder> latLonOptions) {
            return this.latLonOptions((LatLonOptions)((LatLonOptions.Builder)LatLonOptions.builder().applyMutation(latLonOptions)).build());
        }

        public Builder intArrayOptions(IntArrayOptions var1);

        default public Builder intArrayOptions(Consumer<IntArrayOptions.Builder> intArrayOptions) {
            return this.intArrayOptions((IntArrayOptions)((IntArrayOptions.Builder)IntArrayOptions.builder().applyMutation(intArrayOptions)).build());
        }

        public Builder doubleArrayOptions(DoubleArrayOptions var1);

        default public Builder doubleArrayOptions(Consumer<DoubleArrayOptions.Builder> doubleArrayOptions) {
            return this.doubleArrayOptions((DoubleArrayOptions)((DoubleArrayOptions.Builder)DoubleArrayOptions.builder().applyMutation(doubleArrayOptions)).build());
        }

        public Builder literalArrayOptions(LiteralArrayOptions var1);

        default public Builder literalArrayOptions(Consumer<LiteralArrayOptions.Builder> literalArrayOptions) {
            return this.literalArrayOptions((LiteralArrayOptions)((LiteralArrayOptions.Builder)LiteralArrayOptions.builder().applyMutation(literalArrayOptions)).build());
        }

        public Builder textArrayOptions(TextArrayOptions var1);

        default public Builder textArrayOptions(Consumer<TextArrayOptions.Builder> textArrayOptions) {
            return this.textArrayOptions((TextArrayOptions)((TextArrayOptions.Builder)TextArrayOptions.builder().applyMutation(textArrayOptions)).build());
        }

        public Builder dateArrayOptions(DateArrayOptions var1);

        default public Builder dateArrayOptions(Consumer<DateArrayOptions.Builder> dateArrayOptions) {
            return this.dateArrayOptions((DateArrayOptions)((DateArrayOptions.Builder)DateArrayOptions.builder().applyMutation(dateArrayOptions)).build());
        }
    }
}

