/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterStatus;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSuggestersResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeSuggestersResponse> {
    private final List<SuggesterStatus> suggesters;

    private DescribeSuggestersResponse(BuilderImpl builder) {
        super(builder);
        this.suggesters = builder.suggesters;
    }

    public List<SuggesterStatus> suggesters() {
        return this.suggesters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suggesters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersResponse)) {
            return false;
        }
        DescribeSuggestersResponse other = (DescribeSuggestersResponse)((Object)obj);
        return Objects.equals(this.suggesters(), other.suggesters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSuggestersResponse").add("Suggesters", this.suggesters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Suggesters": {
                return Optional.ofNullable(clazz.cast(this.suggesters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<SuggesterStatus> suggesters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSuggestersResponse model) {
            super(model);
            this.suggesters(model.suggesters);
        }

        public final Collection<SuggesterStatus.Builder> getSuggesters() {
            return this.suggesters != null ? (Collection)this.suggesters.stream().map(SuggesterStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggesters(Collection<SuggesterStatus> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copy(suggesters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesters(SuggesterStatus ... suggesters) {
            this.suggesters(Arrays.asList(suggesters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesters(Consumer<SuggesterStatus.Builder> ... suggesters) {
            this.suggesters(Stream.of(suggesters).map(c -> (SuggesterStatus)((SuggesterStatus.Builder)SuggesterStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuggesters(Collection<SuggesterStatus.BuilderImpl> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copyFromBuilder(suggesters);
        }

        @Override
        public DescribeSuggestersResponse build() {
            return new DescribeSuggestersResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    CopyableBuilder<Builder, DescribeSuggestersResponse> {
        public Builder suggesters(Collection<SuggesterStatus> var1);

        public Builder suggesters(SuggesterStatus ... var1);

        public Builder suggesters(Consumer<SuggesterStatus.Builder> ... var1);
    }
}

