/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisScheme;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefineAnalysisSchemeRequest
extends CloudSearchRequest
implements ToCopyableBuilder<Builder, DefineAnalysisSchemeRequest> {
    private final String domainName;
    private final AnalysisScheme analysisScheme;

    private DefineAnalysisSchemeRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.analysisScheme = builder.analysisScheme;
    }

    public String domainName() {
        return this.domainName;
    }

    public AnalysisScheme analysisScheme() {
        return this.analysisScheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisScheme());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefineAnalysisSchemeRequest)) {
            return false;
        }
        DefineAnalysisSchemeRequest other = (DefineAnalysisSchemeRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.analysisScheme(), other.analysisScheme());
    }

    public String toString() {
        return ToString.builder((String)"DefineAnalysisSchemeRequest").add("DomainName", (Object)this.domainName()).add("AnalysisScheme", (Object)this.analysisScheme()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AnalysisScheme": {
                return Optional.ofNullable(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private AnalysisScheme analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(DefineAnalysisSchemeRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.analysisScheme(model.analysisScheme);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final AnalysisScheme.Builder getAnalysisScheme() {
            return this.analysisScheme != null ? this.analysisScheme.toBuilder() : null;
        }

        @Override
        public final Builder analysisScheme(AnalysisScheme analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(AnalysisScheme.BuilderImpl analysisScheme) {
            this.analysisScheme = analysisScheme != null ? analysisScheme.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DefineAnalysisSchemeRequest build() {
            return new DefineAnalysisSchemeRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchRequest.Builder,
    CopyableBuilder<Builder, DefineAnalysisSchemeRequest> {
        public Builder domainName(String var1);

        public Builder analysisScheme(AnalysisScheme var1);

        default public Builder analysisScheme(Consumer<AnalysisScheme.Builder> analysisScheme) {
            return this.analysisScheme((AnalysisScheme)((AnalysisScheme.Builder)AnalysisScheme.builder().applyMutation(analysisScheme)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

