/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.SuggestModelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuggestModel
implements StructuredPojo,
ToCopyableBuilder<Builder, SuggestModel> {
    private final String query;
    private final Long found;
    private final List<SuggestionMatch> suggestions;

    private SuggestModel(BuilderImpl builder) {
        this.query = builder.query;
        this.found = builder.found;
        this.suggestions = builder.suggestions;
    }

    public String query() {
        return this.query;
    }

    public Long found() {
        return this.found;
    }

    public List<SuggestionMatch> suggestions() {
        return this.suggestions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.found());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestModel)) {
            return false;
        }
        SuggestModel other = (SuggestModel)obj;
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.found(), other.found()) && Objects.equals(this.suggestions(), other.suggestions());
    }

    public String toString() {
        return ToString.builder((String)"SuggestModel").add("Query", (Object)this.query()).add("Found", (Object)this.found()).add("Suggestions", this.suggestions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "found": {
                return Optional.of(clazz.cast(this.found()));
            }
            case "suggestions": {
                return Optional.of(clazz.cast(this.suggestions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SuggestModelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String query;
        private Long found;
        private List<SuggestionMatch> suggestions;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestModel model) {
            this.query(model.query);
            this.found(model.found);
            this.suggestions(model.suggestions);
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final Long getFound() {
            return this.found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final Collection<SuggestionMatch.Builder> getSuggestions() {
            return this.suggestions != null ? (Collection)this.suggestions.stream().map(SuggestionMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggestions(Collection<SuggestionMatch> suggestions) {
            this.suggestions = SuggestionsCopier.copy(suggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(SuggestionMatch ... suggestions) {
            this.suggestions(Arrays.asList(suggestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Consumer<SuggestionMatch.Builder> ... suggestions) {
            this.suggestions(Stream.of(suggestions).map(c -> (SuggestionMatch)((SuggestionMatch.Builder)SuggestionMatch.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuggestions(Collection<SuggestionMatch.BuilderImpl> suggestions) {
            this.suggestions = SuggestionsCopier.copyFromBuilder(suggestions);
        }

        public SuggestModel build() {
            return new SuggestModel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuggestModel> {
        public Builder query(String var1);

        public Builder found(Long var1);

        public Builder suggestions(Collection<SuggestionMatch> var1);

        public Builder suggestions(SuggestionMatch ... var1);

        public Builder suggestions(Consumer<SuggestionMatch.Builder> ... var1);
    }
}

