/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudsearchdomain.model.ExprsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.HighlightsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.transform.HitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Hit
implements StructuredPojo,
ToCopyableBuilder<Builder, Hit> {
    private final String id;
    private final Map<String, List<String>> fields;
    private final Map<String, String> exprs;
    private final Map<String, String> highlights;

    private Hit(BuilderImpl builder) {
        this.id = builder.id;
        this.fields = builder.fields;
        this.exprs = builder.exprs;
        this.highlights = builder.highlights;
    }

    public String id() {
        return this.id;
    }

    public Map<String, List<String>> fields() {
        return this.fields;
    }

    public Map<String, String> exprs() {
        return this.exprs;
    }

    public Map<String, String> highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.fields());
        hashCode = 31 * hashCode + Objects.hashCode(this.exprs());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlights());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hit)) {
            return false;
        }
        Hit other = (Hit)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.exprs(), other.exprs()) && Objects.equals(this.highlights(), other.highlights());
    }

    public String toString() {
        return ToString.builder((String)"Hit").add("Id", (Object)this.id()).add("Fields", this.fields()).add("Exprs", this.exprs()).add("Highlights", this.highlights()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "fields": {
                return Optional.of(clazz.cast(this.fields()));
            }
            case "exprs": {
                return Optional.of(clazz.cast(this.exprs()));
            }
            case "highlights": {
                return Optional.of(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, List<String>> fields;
        private Map<String, String> exprs;
        private Map<String, String> highlights;

        private BuilderImpl() {
        }

        private BuilderImpl(Hit model) {
            this.id(model.id);
            this.fields(model.fields);
            this.exprs(model.exprs);
            this.highlights(model.highlights);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, ? extends Collection<String>> getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
        }

        public final Map<String, String> getExprs() {
            return this.exprs;
        }

        @Override
        public final Builder exprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
            return this;
        }

        public final void setExprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
        }

        public final Map<String, String> getHighlights() {
            return this.highlights;
        }

        @Override
        public final Builder highlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        public final void setHighlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
        }

        public Hit build() {
            return new Hit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Hit> {
        public Builder id(String var1);

        public Builder fields(Map<String, ? extends Collection<String>> var1);

        public Builder exprs(Map<String, String> var1);

        public Builder highlights(Map<String, String> var1);
    }
}

