/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.DoubleArrayOptions;

public class DoubleArrayOptionsUnmarshaller
implements Unmarshaller<DoubleArrayOptions, StaxUnmarshallerContext> {
    private static DoubleArrayOptionsUnmarshaller INSTANCE;

    public DoubleArrayOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DoubleArrayOptions.Builder doubleArrayOptions = DoubleArrayOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    doubleArrayOptions.defaultValue(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceFields", targetDepth)) {
                    doubleArrayOptions.sourceFields(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FacetEnabled", targetDepth)) {
                    doubleArrayOptions.facetEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchEnabled", targetDepth)) {
                    doubleArrayOptions.searchEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReturnEnabled", targetDepth)) continue;
                doubleArrayOptions.returnEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DoubleArrayOptions)doubleArrayOptions.build();
    }

    public static DoubleArrayOptionsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DoubleArrayOptionsUnmarshaller();
        }
        return INSTANCE;
    }
}

