/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDomainsRequestMarshaller
implements Marshaller<Request<DescribeDomainsRequest>, DescribeDomainsRequest> {
    public Request<DescribeDomainsRequest> marshall(DescribeDomainsRequest describeDomainsRequest) {
        if (describeDomainsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDomainsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeDomains");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList domainNamesList = (SdkInternalList)describeDomainsRequest.domainNames();
        if (!domainNamesList.isEmpty() || !domainNamesList.isAutoConstruct()) {
            int domainNamesListIndex = 1;
            for (String domainNamesListValue : domainNamesList) {
                if (domainNamesListValue != null) {
                    request.addParameter("DomainNames.member." + domainNamesListIndex, StringUtils.fromString((String)domainNamesListValue));
                }
                ++domainNamesListIndex;
            }
        }
        return request;
    }
}

